// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class AnalyticsSynapseArtifactsModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.CloudError"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="target"> Property name/path in request associated with error. </param>
        /// <param name="details"> Array with additional error details. </param>
        /// <returns> A new <see cref="Models.CloudError"/> instance for mocking. </returns>
        public static CloudError CloudError(string code = null, string message = null, string target = null, IEnumerable<CloudError> details = null)
        {
            details ??= new List<CloudError>();

            return new CloudError(code, message, target, details?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.LinkConnectionDetailedStatus"/>. </summary>
        /// <param name="id"> Link connection id. </param>
        /// <param name="name"> Link connection name. </param>
        /// <param name="isApplyingChanges"> Is link connection applying changes. </param>
        /// <param name="isPartiallyFailed"> Is link connection partially failed. </param>
        /// <param name="startTime"> Link connection start time. </param>
        /// <param name="stopTime"> Link connection stop time. </param>
        /// <param name="status"> Link connection status, please refer to this [articles](https://learn.microsoft.com/azure/synapse-analytics/synapse-link/sql-database-synapse-link#monitoring) for details. </param>
        /// <param name="continuousRunId"> Link connection's corresponding continuous run id. </param>
        /// <param name="error"> Link connection error. </param>
        /// <param name="refreshStatus"> Link connection refresh status. </param>
        /// <param name="landingZoneCredentialExpireTime"> Link connection landing zone credential expire time. </param>
        /// <returns> A new <see cref="Models.LinkConnectionDetailedStatus"/> instance for mocking. </returns>
        public static LinkConnectionDetailedStatus LinkConnectionDetailedStatus(string id = null, string name = null, bool? isApplyingChanges = null, bool? isPartiallyFailed = null, object startTime = null, object stopTime = null, string status = null, string continuousRunId = null, object error = null, LinkConnectionRefreshStatus refreshStatus = null, DateTimeOffset? landingZoneCredentialExpireTime = null)
        {
            return new LinkConnectionDetailedStatus(
                id,
                name,
                isApplyingChanges,
                isPartiallyFailed,
                startTime,
                stopTime,
                status,
                continuousRunId,
                error,
                refreshStatus,
                landingZoneCredentialExpireTime);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LinkConnectionRefreshStatus"/>. </summary>
        /// <param name="refreshStatus"> Link connection refresh status. </param>
        /// <param name="errorMessage"> Link connection refresh error message. </param>
        /// <returns> A new <see cref="Models.LinkConnectionRefreshStatus"/> instance for mocking. </returns>
        public static LinkConnectionRefreshStatus LinkConnectionRefreshStatus(string refreshStatus = null, string errorMessage = null)
        {
            return new LinkConnectionRefreshStatus(refreshStatus, errorMessage);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LinkTableListResponse"/>. </summary>
        /// <param name="value"> List link table value. </param>
        /// <returns> A new <see cref="Models.LinkTableListResponse"/> instance for mocking. </returns>
        public static LinkTableListResponse LinkTableListResponse(IEnumerable<LinkTableResource> value = null)
        {
            value ??= new List<LinkTableResource>();

            return new LinkTableListResponse(value?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.LinkTableResource"/>. </summary>
        /// <param name="id"> Link table id. </param>
        /// <param name="name"> Link table name. </param>
        /// <param name="source"> Source table properties for link table request. </param>
        /// <param name="target"> Target table properties for link table request. </param>
        /// <returns> A new <see cref="Models.LinkTableResource"/> instance for mocking. </returns>
        public static LinkTableResource LinkTableResource(string id = null, string name = null, LinkTableRequestSource source = null, LinkTableRequestTarget target = null)
        {
            return new LinkTableResource(id, name, source, target);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LinkConnectionQueryTableStatus"/>. </summary>
        /// <param name="value"> Link tables' status. </param>
        /// <param name="continuationToken"> Continuation token to query table status. </param>
        /// <returns> A new <see cref="Models.LinkConnectionQueryTableStatus"/> instance for mocking. </returns>
        public static LinkConnectionQueryTableStatus LinkConnectionQueryTableStatus(IEnumerable<LinkTableStatus> value = null, object continuationToken = null)
        {
            value ??= new List<LinkTableStatus>();

            return new LinkConnectionQueryTableStatus(value?.ToList(), continuationToken);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LinkTableStatus"/>. </summary>
        /// <param name="id"> ID provided by the client. </param>
        /// <param name="status"> Link table status, please refer to this [articles](https://learn.microsoft.com/azure/synapse-analytics/synapse-link/sql-database-synapse-link#monitoring) for details. </param>
        /// <param name="errorMessage"> Link table error message. </param>
        /// <param name="startTime"> Link table start time. </param>
        /// <param name="stopTime"> Link table stop time. </param>
        /// <param name="linkTableId"> Link table ID. </param>
        /// <param name="errorCode"> Link table error code. </param>
        /// <param name="lastProcessedData"> Link table last processed data time. </param>
        /// <param name="lastTransactionCommitTime"> Link table last transaction commit time. </param>
        /// <returns> A new <see cref="Models.LinkTableStatus"/> instance for mocking. </returns>
        public static LinkTableStatus LinkTableStatus(string id = null, string status = null, string errorMessage = null, object startTime = null, object stopTime = null, string linkTableId = null, string errorCode = null, DateTimeOffset? lastProcessedData = null, DateTimeOffset? lastTransactionCommitTime = null)
        {
            return new LinkTableStatus(
                id,
                status,
                errorMessage,
                startTime,
                stopTime,
                linkTableId,
                errorCode,
                lastProcessedData,
                lastTransactionCommitTime);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RunNotebookResponse"/>. </summary>
        /// <param name="message"> Response message. </param>
        /// <param name="result"> Result of run notebook. </param>
        /// <returns> A new <see cref="Models.RunNotebookResponse"/> instance for mocking. </returns>
        public static RunNotebookResponse RunNotebookResponse(string message = null, RunNotebookResult result = null)
        {
            return new RunNotebookResponse(message, result);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RunNotebookResult"/>. </summary>
        /// <param name="runId"> Run id. </param>
        /// <param name="runStatus"> Status of the run notebook. </param>
        /// <param name="lastCheckedOn"> Timestamp of last update. </param>
        /// <param name="sessionId"> Livy session id. </param>
        /// <param name="sparkPool"> SparkPool name. </param>
        /// <param name="sessionDetail"> Run notebook session details. </param>
        /// <param name="exitValue"> Output of exit command. </param>
        /// <param name="error"> Run notebook error. </param>
        /// <returns> A new <see cref="Models.RunNotebookResult"/> instance for mocking. </returns>
        public static RunNotebookResult RunNotebookResult(string runId = null, string runStatus = null, string lastCheckedOn = null, string sessionId = null, string sparkPool = null, object sessionDetail = null, string exitValue = null, RunNotebookError error = null)
        {
            return new RunNotebookResult(
                runId,
                runStatus,
                lastCheckedOn,
                sessionId,
                sparkPool,
                sessionDetail,
                exitValue,
                error);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RunNotebookError"/>. </summary>
        /// <param name="ename"> Error name. </param>
        /// <param name="evalue"> Error message. </param>
        /// <param name="traceback"> Error trace. </param>
        /// <returns> A new <see cref="Models.RunNotebookError"/> instance for mocking. </returns>
        public static RunNotebookError RunNotebookError(string ename = null, string evalue = null, IEnumerable<string> traceback = null)
        {
            traceback ??= new List<string>();

            return new RunNotebookError(ename, evalue, traceback?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.RunNotebookSnapshotResponse"/>. </summary>
        /// <param name="message"> Response message. </param>
        /// <param name="result"> Run notebook snapshot result. </param>
        /// <returns> A new <see cref="Models.RunNotebookSnapshotResponse"/> instance for mocking. </returns>
        public static RunNotebookSnapshotResponse RunNotebookSnapshotResponse(string message = null, RunNotebookSnapshotResult result = null)
        {
            return new RunNotebookSnapshotResponse(message, result);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RunNotebookSnapshotResult"/>. </summary>
        /// <param name="snapshot"> Run notebook snapshot. </param>
        /// <param name="error"> Run notebook error. </param>
        /// <param name="runId"> Run id. </param>
        /// <param name="runStatus"> Status of the run notebook. </param>
        /// <param name="lastCheckedOn"> Timestamp of last update. </param>
        /// <param name="sessionId"> Livy session id. </param>
        /// <param name="sparkPool"> SparkPool name. </param>
        /// <returns> A new <see cref="Models.RunNotebookSnapshotResult"/> instance for mocking. </returns>
        public static RunNotebookSnapshotResult RunNotebookSnapshotResult(RunNotebookSnapshot snapshot = null, RunNotebookError error = null, string runId = null, string runStatus = null, string lastCheckedOn = null, string sessionId = null, string sparkPool = null)
        {
            return new RunNotebookSnapshotResult(
                snapshot,
                error,
                runId,
                runStatus,
                lastCheckedOn,
                sessionId,
                sparkPool);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RunNotebookSnapshot"/>. </summary>
        /// <param name="exitValue"> Output of exit command. </param>
        /// <param name="id"> Run notebook runId. </param>
        /// <param name="notebook"> Notebook name. </param>
        /// <param name="sessionOptions"> Session properties. </param>
        /// <param name="honorSessionTimeToLive"> Whether session should run till time to live after run completes. </param>
        /// <param name="sessionId"> Livy session id. </param>
        /// <param name="sparkPool"> SparkPool name. </param>
        /// <param name="parameters"> Run notebook parameters. </param>
        /// <param name="notebookContent"> Notebook resource type. </param>
        /// <returns> A new <see cref="Models.RunNotebookSnapshot"/> instance for mocking. </returns>
        public static RunNotebookSnapshot RunNotebookSnapshot(string exitValue = null, string id = null, string notebook = null, RunNotebookSparkSessionOptions sessionOptions = null, bool? honorSessionTimeToLive = null, string sessionId = null, string sparkPool = null, IReadOnlyDictionary<string, RunNotebookParameter> parameters = null, NotebookResource notebookContent = null)
        {
            parameters ??= new Dictionary<string, RunNotebookParameter>();

            return new RunNotebookSnapshot(
                exitValue,
                id,
                notebook,
                sessionOptions,
                honorSessionTimeToLive,
                sessionId,
                sparkPool,
                parameters,
                notebookContent);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NotebookResource"/>. </summary>
        /// <param name="id"> Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts. </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties"> Properties of Notebook. </param>
        /// <returns> A new <see cref="Models.NotebookResource"/> instance for mocking. </returns>
        public static NotebookResource NotebookResource(string id = null, string name = null, string type = null, string etag = null, Notebook properties = null)
        {
            return new NotebookResource(id, name, type, etag, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MetastoreRegistrationResponse"/>. </summary>
        /// <param name="status"> Enumerates possible request statuses. </param>
        /// <returns> A new <see cref="Models.MetastoreRegistrationResponse"/> instance for mocking. </returns>
        public static MetastoreRegistrationResponse MetastoreRegistrationResponse(RequestStatus? status = null)
        {
            return new MetastoreRegistrationResponse(status);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MetastoreRequestSuccessResponse"/>. </summary>
        /// <param name="status"> Enumerates possible Status of the resource. </param>
        /// <returns> A new <see cref="Models.MetastoreRequestSuccessResponse"/> instance for mocking. </returns>
        public static MetastoreRequestSuccessResponse MetastoreRequestSuccessResponse(ResourceStatus? status = null)
        {
            return new MetastoreRequestSuccessResponse(status);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MetastoreUpdationResponse"/>. </summary>
        /// <param name="status"> Enumerates possible request statuses. </param>
        /// <returns> A new <see cref="Models.MetastoreUpdationResponse"/> instance for mocking. </returns>
        public static MetastoreUpdationResponse MetastoreUpdationResponse(RequestStatus? status = null)
        {
            return new MetastoreUpdationResponse(status);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkConfigurationResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties"> Properties of Spark Configuration. </param>
        /// <returns> A new <see cref="Models.SparkConfigurationResource"/> instance for mocking. </returns>
        public static SparkConfigurationResource SparkConfigurationResource(string id = null, string name = null, string type = null, string etag = null, SparkConfiguration properties = null)
        {
            return new SparkConfigurationResource(id, name, type, etag, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SubResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <returns> A new <see cref="Models.SubResource"/> instance for mocking. </returns>
        public static SubResource SubResource(string id = null, string name = null, string type = null, string etag = null)
        {
            return new SubResource(id, name, type, etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureEntityResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <returns> A new <see cref="Models.AzureEntityResource"/> instance for mocking. </returns>
        public static AzureEntityResource AzureEntityResource(string id = null, string name = null, string type = null, string etag = null)
        {
            return new AzureEntityResource(id, name, type, etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.Resource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <returns> A new <see cref="Models.Resource"/> instance for mocking. </returns>
        public static Resource Resource(string id = null, string name = null, string type = null)
        {
            return new Resource(id, name, type);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BigDataPoolResourceInfoListResult"/>. </summary>
        /// <param name="nextLink"> Link to the next page of results. </param>
        /// <param name="value"> List of Big Data pools. </param>
        /// <returns> A new <see cref="Models.BigDataPoolResourceInfoListResult"/> instance for mocking. </returns>
        public static BigDataPoolResourceInfoListResult BigDataPoolResourceInfoListResult(string nextLink = null, IEnumerable<BigDataPoolResourceInfo> value = null)
        {
            value ??= new List<BigDataPoolResourceInfo>();

            return new BigDataPoolResourceInfoListResult(nextLink, value?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.BigDataPoolResourceInfo"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="provisioningState"> The state of the Big Data pool. </param>
        /// <param name="autoScale"> Auto-scaling properties. </param>
        /// <param name="creationDate"> The time when the Big Data pool was created. </param>
        /// <param name="autoPause"> Auto-pausing properties. </param>
        /// <param name="isComputeIsolationEnabled"> Whether compute isolation is required or not. </param>
        /// <param name="sessionLevelPackagesEnabled"> Whether session level packages enabled. </param>
        /// <param name="cacheSize"> The cache size. </param>
        /// <param name="dynamicExecutorAllocation"> Dynamic Executor Allocation. </param>
        /// <param name="sparkEventsFolder"> The Spark events folder. </param>
        /// <param name="nodeCount"> The number of nodes in the Big Data pool. </param>
        /// <param name="libraryRequirements"> Library version requirements. </param>
        /// <param name="customLibraries"> List of custom libraries/packages associated with the spark pool. </param>
        /// <param name="sparkConfigProperties"> Spark configuration file to specify additional properties. </param>
        /// <param name="sparkVersion"> The Apache Spark version. </param>
        /// <param name="defaultSparkLogFolder"> The default folder where Spark logs will be written. </param>
        /// <param name="nodeSize"> The level of compute power that each node in the Big Data pool has. </param>
        /// <param name="nodeSizeFamily"> The kind of nodes that the Big Data pool provides. </param>
        /// <param name="lastSucceededTimestamp"> The time when the Big Data pool was updated successfully. </param>
        /// <returns> A new <see cref="Models.BigDataPoolResourceInfo"/> instance for mocking. </returns>
        public static BigDataPoolResourceInfo BigDataPoolResourceInfo(string id = null, string name = null, string type = null, IDictionary<string, string> tags = null, string location = null, string provisioningState = null, AutoScaleProperties autoScale = null, DateTimeOffset? creationDate = null, AutoPauseProperties autoPause = null, bool? isComputeIsolationEnabled = null, bool? sessionLevelPackagesEnabled = null, int? cacheSize = null, DynamicExecutorAllocation dynamicExecutorAllocation = null, string sparkEventsFolder = null, int? nodeCount = null, LibraryRequirements libraryRequirements = null, IEnumerable<LibraryInfo> customLibraries = null, LibraryRequirements sparkConfigProperties = null, string sparkVersion = null, string defaultSparkLogFolder = null, NodeSize? nodeSize = null, NodeSizeFamily? nodeSizeFamily = null, DateTimeOffset? lastSucceededTimestamp = null)
        {
            tags ??= new Dictionary<string, string>();
            customLibraries ??= new List<LibraryInfo>();

            return new BigDataPoolResourceInfo(
                id,
                name,
                type,
                tags,
                location,
                provisioningState,
                autoScale,
                creationDate,
                autoPause,
                isComputeIsolationEnabled,
                sessionLevelPackagesEnabled,
                cacheSize,
                dynamicExecutorAllocation,
                sparkEventsFolder,
                nodeCount,
                libraryRequirements,
                customLibraries?.ToList(),
                sparkConfigProperties,
                sparkVersion,
                defaultSparkLogFolder,
                nodeSize,
                nodeSizeFamily,
                lastSucceededTimestamp);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LibraryRequirements"/>. </summary>
        /// <param name="time"> The last update time of the library requirements file. </param>
        /// <param name="content"> The library requirements. </param>
        /// <param name="filename"> The filename of the library requirements file. </param>
        /// <returns> A new <see cref="Models.LibraryRequirements"/> instance for mocking. </returns>
        public static LibraryRequirements LibraryRequirements(DateTimeOffset? time = null, string content = null, string filename = null)
        {
            return new LibraryRequirements(time, content, filename);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LibraryInfo"/>. </summary>
        /// <param name="name"> Name of the library. </param>
        /// <param name="path"> Storage blob path of library. </param>
        /// <param name="containerName"> Storage blob container name. </param>
        /// <param name="uploadedTimestamp"> The last update time of the library. </param>
        /// <param name="type"> Type of the library. </param>
        /// <param name="provisioningStatus"> Provisioning status of the library/package. </param>
        /// <param name="creatorId"> Creator Id of the library/package. </param>
        /// <returns> A new <see cref="Models.LibraryInfo"/> instance for mocking. </returns>
        public static LibraryInfo LibraryInfo(string name = null, string path = null, string containerName = null, DateTimeOffset? uploadedTimestamp = null, string type = null, string provisioningStatus = null, string creatorId = null)
        {
            return new LibraryInfo(
                name,
                path,
                containerName,
                uploadedTimestamp,
                type,
                provisioningStatus,
                creatorId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TrackedResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <returns> A new <see cref="Models.TrackedResource"/> instance for mocking. </returns>
        public static TrackedResource TrackedResource(string id = null, string name = null, string type = null, IDictionary<string, string> tags = null, string location = null)
        {
            tags ??= new Dictionary<string, string>();

            return new TrackedResource(id, name, type, tags, location);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFlowResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties">
        /// Data flow properties.
        /// Please note <see cref="DataFlow"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Flowlet"/> and <see cref="MappingDataFlow"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataFlowResource"/> instance for mocking. </returns>
        public static DataFlowResource DataFlowResource(string id = null, string name = null, string type = null, string etag = null, DataFlow properties = null)
        {
            return new DataFlowResource(id, name, type, etag, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CreateDataFlowDebugSessionResponse"/>. </summary>
        /// <param name="sessionId"> The ID of data flow debug session. </param>
        /// <returns> A new <see cref="Models.CreateDataFlowDebugSessionResponse"/> instance for mocking. </returns>
        public static CreateDataFlowDebugSessionResponse CreateDataFlowDebugSessionResponse(string sessionId = null)
        {
            return new CreateDataFlowDebugSessionResponse(sessionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFlowDebugSessionInfo"/>. </summary>
        /// <param name="dataFlowName"> The name of the data flow. </param>
        /// <param name="computeType"> Compute type of the cluster. </param>
        /// <param name="coreCount"> Core count of the cluster. </param>
        /// <param name="nodeCount"> Node count of the cluster. (deprecated property). </param>
        /// <param name="integrationRuntimeName"> Attached integration runtime name of data flow debug session. </param>
        /// <param name="sessionId"> The ID of data flow debug session. </param>
        /// <param name="startTime"> Start time of data flow debug session. </param>
        /// <param name="timeToLiveInMinutes"> Compute type of the cluster. </param>
        /// <param name="lastActivityTime"> Last activity time of data flow debug session. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.DataFlowDebugSessionInfo"/> instance for mocking. </returns>
        public static DataFlowDebugSessionInfo DataFlowDebugSessionInfo(string dataFlowName = null, string computeType = null, int? coreCount = null, int? nodeCount = null, string integrationRuntimeName = null, string sessionId = null, string startTime = null, int? timeToLiveInMinutes = null, string lastActivityTime = null, IReadOnlyDictionary<string, object> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, object>();

            return new DataFlowDebugSessionInfo(
                dataFlowName,
                computeType,
                coreCount,
                nodeCount,
                integrationRuntimeName,
                sessionId,
                startTime,
                timeToLiveInMinutes,
                lastActivityTime,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AddDataFlowToDebugSessionResponse"/>. </summary>
        /// <param name="jobVersion"> The ID of data flow debug job version. </param>
        /// <returns> A new <see cref="Models.AddDataFlowToDebugSessionResponse"/> instance for mocking. </returns>
        public static AddDataFlowToDebugSessionResponse AddDataFlowToDebugSessionResponse(string jobVersion = null)
        {
            return new AddDataFlowToDebugSessionResponse(jobVersion);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFlowDebugCommandResponse"/>. </summary>
        /// <param name="status"> The run status of data preview, statistics or expression preview. </param>
        /// <param name="data"> The result data of data preview, statistics or expression preview. </param>
        /// <returns> A new <see cref="Models.DataFlowDebugCommandResponse"/> instance for mocking. </returns>
        public static DataFlowDebugCommandResponse DataFlowDebugCommandResponse(string status = null, string data = null)
        {
            return new DataFlowDebugCommandResponse(status, data);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DatasetResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties">
        /// Dataset properties.
        /// Please note <see cref="Dataset"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AmazonMWSObjectDataset"/>, <see cref="AmazonRdsForOracleTableDataset"/>, <see cref="AmazonRdsForSqlServerTableDataset"/>, <see cref="AmazonRedshiftTableDataset"/>, <see cref="AmazonS3Dataset"/>, <see cref="AvroDataset"/>, <see cref="AzureBlobDataset"/>, <see cref="AzureBlobFSDataset"/>, <see cref="AzureDatabricksDeltaLakeDataset"/>, <see cref="AzureDataExplorerTableDataset"/>, <see cref="AzureDataLakeStoreDataset"/>, <see cref="AzureMariaDBTableDataset"/>, <see cref="AzureMySqlTableDataset"/>, <see cref="AzurePostgreSqlTableDataset"/>, <see cref="AzureSearchIndexDataset"/>, <see cref="AzureSqlDWTableDataset"/>, <see cref="AzureSqlMITableDataset"/>, <see cref="AzureSqlTableDataset"/>, <see cref="AzureTableDataset"/>, <see cref="BinaryDataset"/>, <see cref="CassandraTableDataset"/>, <see cref="CommonDataServiceForAppsEntityDataset"/>, <see cref="ConcurObjectDataset"/>, <see cref="CosmosDbMongoDbApiCollectionDataset"/>, <see cref="CosmosDbSqlApiCollectionDataset"/>, <see cref="CouchbaseTableDataset"/>, <see cref="CustomDataset"/>, <see cref="Db2TableDataset"/>, <see cref="DelimitedTextDataset"/>, <see cref="DocumentDbCollectionDataset"/>, <see cref="DrillTableDataset"/>, <see cref="DynamicsAXResourceDataset"/>, <see cref="DynamicsCrmEntityDataset"/>, <see cref="DynamicsEntityDataset"/>, <see cref="EloquaObjectDataset"/>, <see cref="ExcelDataset"/>, <see cref="FileShareDataset"/>, <see cref="GoogleAdWordsObjectDataset"/>, <see cref="GoogleBigQueryObjectDataset"/>, <see cref="GoogleBigQueryV2ObjectDataset"/>, <see cref="GreenplumTableDataset"/>, <see cref="HBaseObjectDataset"/>, <see cref="HiveObjectDataset"/>, <see cref="HttpDataset"/>, <see cref="HubspotObjectDataset"/>, <see cref="ImpalaObjectDataset"/>, <see cref="InformixTableDataset"/>, <see cref="JiraObjectDataset"/>, <see cref="JsonDataset"/>, <see cref="LakeHouseTableDataset"/>, <see cref="MagentoObjectDataset"/>, <see cref="MariaDBTableDataset"/>, <see cref="MarketoObjectDataset"/>, <see cref="MicrosoftAccessTableDataset"/>, <see cref="MongoDbAtlasCollectionDataset"/>, <see cref="MongoDbCollectionDataset"/>, <see cref="MongoDbV2CollectionDataset"/>, <see cref="MySqlTableDataset"/>, <see cref="NetezzaTableDataset"/>, <see cref="ODataResourceDataset"/>, <see cref="OdbcTableDataset"/>, <see cref="Office365Dataset"/>, <see cref="OracleServiceCloudObjectDataset"/>, <see cref="OracleTableDataset"/>, <see cref="OrcDataset"/>, <see cref="ParquetDataset"/>, <see cref="PaypalObjectDataset"/>, <see cref="PhoenixObjectDataset"/>, <see cref="PostgreSqlTableDataset"/>, <see cref="PostgreSqlV2TableDataset"/>, <see cref="PrestoObjectDataset"/>, <see cref="QuickBooksObjectDataset"/>, <see cref="RelationalTableDataset"/>, <see cref="ResponsysObjectDataset"/>, <see cref="RestResourceDataset"/>, <see cref="SalesforceMarketingCloudObjectDataset"/>, <see cref="SalesforceObjectDataset"/>, <see cref="SalesforceServiceCloudObjectDataset"/>, <see cref="SalesforceServiceCloudV2ObjectDataset"/>, <see cref="SalesforceV2ObjectDataset"/>, <see cref="SapBwCubeDataset"/>, <see cref="SapCloudForCustomerResourceDataset"/>, <see cref="SapEccResourceDataset"/>, <see cref="SapHanaTableDataset"/>, <see cref="SapOdpResourceDataset"/>, <see cref="SapOpenHubTableDataset"/>, <see cref="SapTableResourceDataset"/>, <see cref="ServiceNowObjectDataset"/>, <see cref="ServiceNowV2ObjectDataset"/>, <see cref="SharePointOnlineListResourceDataset"/>, <see cref="ShopifyObjectDataset"/>, <see cref="SnowflakeDataset"/>, <see cref="SnowflakeV2Dataset"/>, <see cref="SparkObjectDataset"/>, <see cref="SqlServerTableDataset"/>, <see cref="SquareObjectDataset"/>, <see cref="SybaseTableDataset"/>, <see cref="TeradataTableDataset"/>, <see cref="VerticaTableDataset"/>, <see cref="WarehouseTableDataset"/>, <see cref="WebTableDataset"/>, <see cref="XeroObjectDataset"/>, <see cref="XmlDataset"/> and <see cref="ZohoObjectDataset"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DatasetResource"/> instance for mocking. </returns>
        public static DatasetResource DatasetResource(string id = null, string name = null, string type = null, string etag = null, Dataset properties = null)
        {
            return new DatasetResource(id, name, type, etag, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GitHubAccessTokenResponse"/>. </summary>
        /// <param name="gitHubAccessToken"></param>
        /// <returns> A new <see cref="Models.GitHubAccessTokenResponse"/> instance for mocking. </returns>
        public static GitHubAccessTokenResponse GitHubAccessTokenResponse(string gitHubAccessToken = null)
        {
            return new GitHubAccessTokenResponse(gitHubAccessToken);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationRuntimeListResponse"/>. </summary>
        /// <param name="value"> List of integration runtimes. </param>
        /// <param name="nextLink"> The link to the next page of results, if any remaining results exist. </param>
        /// <returns> A new <see cref="Models.IntegrationRuntimeListResponse"/> instance for mocking. </returns>
        public static IntegrationRuntimeListResponse IntegrationRuntimeListResponse(IEnumerable<IntegrationRuntimeResource> value = null, string nextLink = null)
        {
            value ??= new List<IntegrationRuntimeResource>();

            return new IntegrationRuntimeListResponse(value?.ToList(), nextLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationRuntimeResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties">
        /// Integration runtime properties.
        /// Please note <see cref="IntegrationRuntime"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ManagedIntegrationRuntime"/> and <see cref="SelfHostedIntegrationRuntime"/>.
        /// </param>
        /// <returns> A new <see cref="Models.IntegrationRuntimeResource"/> instance for mocking. </returns>
        public static IntegrationRuntimeResource IntegrationRuntimeResource(string id = null, string name = null, string type = null, string etag = null, IntegrationRuntime properties = null)
        {
            return new IntegrationRuntimeResource(id, name, type, etag, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LibraryResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties"> Library/package properties. </param>
        /// <returns> A new <see cref="Models.LibraryResource"/> instance for mocking. </returns>
        public static LibraryResource LibraryResource(string id = null, string name = null, string type = null, string etag = null, LibraryResourceProperties properties = null)
        {
            return new LibraryResource(id, name, type, etag, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LibraryResourceProperties"/>. </summary>
        /// <param name="name"> Name of the library/package. </param>
        /// <param name="path"> Location of library/package in storage account. </param>
        /// <param name="containerName"> Container name of the library/package. </param>
        /// <param name="uploadedTimestamp"> The last update time of the library/package. </param>
        /// <param name="type"> Type of the library/package. </param>
        /// <param name="provisioningStatus"> Provisioning status of the library/package. </param>
        /// <param name="creatorId"> Creator Id of the library/package. </param>
        /// <returns> A new <see cref="Models.LibraryResourceProperties"/> instance for mocking. </returns>
        public static LibraryResourceProperties LibraryResourceProperties(string name = null, string path = null, string containerName = null, string uploadedTimestamp = null, string type = null, string provisioningStatus = null, string creatorId = null)
        {
            return new LibraryResourceProperties(
                name,
                path,
                containerName,
                uploadedTimestamp,
                type,
                provisioningStatus,
                creatorId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LibraryResourceInfo"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="recordId"> record Id of the library/package. </param>
        /// <param name="state"> Provisioning status of the library/package. </param>
        /// <param name="created"> The creation time of the library/package. </param>
        /// <param name="changed"> The last updated time of the library/package. </param>
        /// <param name="type"> The type of the resource. E.g. LibraryArtifact. </param>
        /// <param name="name"> Name of the library/package. </param>
        /// <param name="operationId"> Operation Id of the operation performed on library/package. </param>
        /// <param name="artifactId"> artifact Id of the library/package. </param>
        /// <returns> A new <see cref="Models.LibraryResourceInfo"/> instance for mocking. </returns>
        public static LibraryResourceInfo LibraryResourceInfo(string id = null, int? recordId = null, string state = null, string created = null, string changed = null, string type = null, string name = null, string operationId = null, string artifactId = null)
        {
            return new LibraryResourceInfo(
                id,
                recordId,
                state,
                created,
                changed,
                type,
                name,
                operationId,
                artifactId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationResult"/>. </summary>
        /// <param name="status"> Operation status. </param>
        /// <param name="code"> Error code. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="target"> Property name/path in request associated with error. </param>
        /// <param name="details"> Array with additional error details. </param>
        /// <returns> A new <see cref="Models.OperationResult"/> instance for mocking. </returns>
        public static OperationResult OperationResult(string status = null, string code = null, string message = null, string target = null, IEnumerable<CloudError> details = null)
        {
            details ??= new List<CloudError>();

            return new OperationResult(status, code, message, target, details?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.LinkedServiceResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties">
        /// Properties of linked service.
        /// Please note <see cref="LinkedService"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AmazonMWSLinkedService"/>, <see cref="AmazonRdsForOracleLinkedService"/>, <see cref="AmazonRdsForSqlServerLinkedService"/>, <see cref="AmazonRedshiftLinkedService"/>, <see cref="AmazonS3LinkedService"/>, <see cref="AppFiguresLinkedService"/>, <see cref="AsanaLinkedService"/>, <see cref="AzureBatchLinkedService"/>, <see cref="AzureBlobFSLinkedService"/>, <see cref="AzureBlobStorageLinkedService"/>, <see cref="AzureDatabricksLinkedService"/>, <see cref="AzureDatabricksDeltaLakeLinkedService"/>, <see cref="AzureDataExplorerLinkedService"/>, <see cref="AzureDataLakeAnalyticsLinkedService"/>, <see cref="AzureDataLakeStoreLinkedService"/>, <see cref="AzureFileStorageLinkedService"/>, <see cref="AzureFunctionLinkedService"/>, <see cref="AzureKeyVaultLinkedService"/>, <see cref="AzureMariaDBLinkedService"/>, <see cref="AzureMLLinkedService"/>, <see cref="AzureMLServiceLinkedService"/>, <see cref="AzureMySqlLinkedService"/>, <see cref="AzurePostgreSqlLinkedService"/>, <see cref="AzureSearchLinkedService"/>, <see cref="AzureSqlDatabaseLinkedService"/>, <see cref="AzureSqlDWLinkedService"/>, <see cref="AzureSqlMILinkedService"/>, <see cref="AzureStorageLinkedService"/>, <see cref="AzureSynapseArtifactsLinkedService"/>, <see cref="AzureTableStorageLinkedService"/>, <see cref="CassandraLinkedService"/>, <see cref="CommonDataServiceForAppsLinkedService"/>, <see cref="ConcurLinkedService"/>, <see cref="CosmosDbLinkedService"/>, <see cref="CosmosDbMongoDbApiLinkedService"/>, <see cref="CouchbaseLinkedService"/>, <see cref="CustomDataSourceLinkedService"/>, <see cref="DataworldLinkedService"/>, <see cref="Db2LinkedService"/>, <see cref="DrillLinkedService"/>, <see cref="DynamicsLinkedService"/>, <see cref="DynamicsAXLinkedService"/>, <see cref="DynamicsCrmLinkedService"/>, <see cref="EloquaLinkedService"/>, <see cref="FileServerLinkedService"/>, <see cref="FtpServerLinkedService"/>, <see cref="GoogleAdWordsLinkedService"/>, <see cref="GoogleBigQueryLinkedService"/>, <see cref="GoogleBigQueryV2LinkedService"/>, <see cref="GoogleCloudStorageLinkedService"/>, <see cref="GoogleSheetsLinkedService"/>, <see cref="GreenplumLinkedService"/>, <see cref="HBaseLinkedService"/>, <see cref="HdfsLinkedService"/>, <see cref="HDInsightLinkedService"/>, <see cref="HDInsightOnDemandLinkedService"/>, <see cref="HiveLinkedService"/>, <see cref="HttpLinkedService"/>, <see cref="HubspotLinkedService"/>, <see cref="ImpalaLinkedService"/>, <see cref="InformixLinkedService"/>, <see cref="JiraLinkedService"/>, <see cref="LakeHouseLinkedService"/>, <see cref="MagentoLinkedService"/>, <see cref="MariaDBLinkedService"/>, <see cref="MarketoLinkedService"/>, <see cref="MicrosoftAccessLinkedService"/>, <see cref="MongoDbLinkedService"/>, <see cref="MongoDbAtlasLinkedService"/>, <see cref="MongoDbV2LinkedService"/>, <see cref="MySqlLinkedService"/>, <see cref="NetezzaLinkedService"/>, <see cref="ODataLinkedService"/>, <see cref="OdbcLinkedService"/>, <see cref="Office365LinkedService"/>, <see cref="OracleLinkedService"/>, <see cref="OracleServiceCloudLinkedService"/>, <see cref="PaypalLinkedService"/>, <see cref="PhoenixLinkedService"/>, <see cref="PostgreSqlLinkedService"/>, <see cref="PostgreSqlV2LinkedService"/>, <see cref="PowerBIWorkspaceLinkedService"/>, <see cref="PrestoLinkedService"/>, <see cref="QuickbaseLinkedService"/>, <see cref="QuickBooksLinkedService"/>, <see cref="ResponsysLinkedService"/>, <see cref="RestServiceLinkedService"/>, <see cref="SalesforceLinkedService"/>, <see cref="SalesforceMarketingCloudLinkedService"/>, <see cref="SalesforceServiceCloudLinkedService"/>, <see cref="SalesforceServiceCloudV2LinkedService"/>, <see cref="SalesforceV2LinkedService"/>, <see cref="SapBWLinkedService"/>, <see cref="SapCloudForCustomerLinkedService"/>, <see cref="SapEccLinkedService"/>, <see cref="SapHanaLinkedService"/>, <see cref="SapOdpLinkedService"/>, <see cref="SapOpenHubLinkedService"/>, <see cref="SapTableLinkedService"/>, <see cref="ServiceNowLinkedService"/>, <see cref="SftpServerLinkedService"/>, <see cref="SharePointOnlineListLinkedService"/>, <see cref="ShopifyLinkedService"/>, <see cref="SmartsheetLinkedService"/>, <see cref="SnowflakeLinkedService"/>, <see cref="SnowflakeV2LinkedService"/>, <see cref="SparkLinkedService"/>, <see cref="SqlServerLinkedService"/>, <see cref="SquareLinkedService"/>, <see cref="SybaseLinkedService"/>, <see cref="TeamDeskLinkedService"/>, <see cref="TeradataLinkedService"/>, <see cref="TwilioLinkedService"/>, <see cref="VerticaLinkedService"/>, <see cref="WarehouseLinkedService"/>, <see cref="WebLinkedService"/>, <see cref="XeroLinkedService"/>, <see cref="ZendeskLinkedService"/> and <see cref="ZohoLinkedService"/>.
        /// </param>
        /// <returns> A new <see cref="Models.LinkedServiceResource"/> instance for mocking. </returns>
        public static LinkedServiceResource LinkedServiceResource(string id = null, string name = null, string type = null, string etag = null, LinkedService properties = null)
        {
            return new LinkedServiceResource(id, name, type, etag, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PipelineResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="description"> The description of the pipeline. </param>
        /// <param name="activities">
        /// List of activities in pipeline.
        /// Please note <see cref="Activity"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AppendVariableActivity"/>, <see cref="AzureDataExplorerCommandActivity"/>, <see cref="AzureFunctionActivity"/>, <see cref="AzureMLBatchExecutionActivity"/>, <see cref="AzureMLExecutePipelineActivity"/>, <see cref="AzureMLUpdateResourceActivity"/>, <see cref="ControlActivity"/>, <see cref="CopyActivity"/>, <see cref="CustomActivity"/>, <see cref="DatabricksNotebookActivity"/>, <see cref="DatabricksSparkJarActivity"/>, <see cref="DatabricksSparkPythonActivity"/>, <see cref="DataLakeAnalyticsUsqlActivity"/>, <see cref="DeleteActivity"/>, <see cref="ExecuteDataFlowActivity"/>, <see cref="ExecutePipelineActivity"/>, <see cref="ExecuteSsisPackageActivity"/>, <see cref="ExecutionActivity"/>, <see cref="FailActivity"/>, <see cref="FilterActivity"/>, <see cref="ForEachActivity"/>, <see cref="GetMetadataActivity"/>, <see cref="HDInsightHiveActivity"/>, <see cref="HDInsightMapReduceActivity"/>, <see cref="HDInsightPigActivity"/>, <see cref="HDInsightSparkActivity"/>, <see cref="HDInsightStreamingActivity"/>, <see cref="IfConditionActivity"/>, <see cref="LookupActivity"/>, <see cref="ScriptActivity"/>, <see cref="SetVariableActivity"/>, <see cref="SynapseSparkJobDefinitionActivity"/>, <see cref="SqlPoolStoredProcedureActivity"/>, <see cref="SqlServerStoredProcedureActivity"/>, <see cref="SwitchActivity"/>, <see cref="SynapseNotebookActivity"/>, <see cref="UntilActivity"/>, <see cref="ValidationActivity"/>, <see cref="WaitActivity"/>, <see cref="WebActivity"/> and <see cref="WebHookActivity"/>.
        /// </param>
        /// <param name="parameters"> List of parameters for pipeline. </param>
        /// <param name="variables"> List of variables for pipeline. </param>
        /// <param name="concurrency"> The max number of concurrent runs for the pipeline. </param>
        /// <param name="annotations"> List of tags that can be used for describing the Pipeline. </param>
        /// <param name="runDimensions"> Dimensions emitted by Pipeline. </param>
        /// <param name="folder"> The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.PipelineResource"/> instance for mocking. </returns>
        public static PipelineResource PipelineResource(string id = null, string name = null, string type = null, string etag = null, string description = null, IEnumerable<Activity> activities = null, IDictionary<string, ParameterSpecification> parameters = null, IDictionary<string, VariableSpecification> variables = null, int? concurrency = null, IEnumerable<object> annotations = null, IDictionary<string, object> runDimensions = null, PipelineFolder folder = null, IDictionary<string, object> additionalProperties = null)
        {
            activities ??= new List<Activity>();
            parameters ??= new Dictionary<string, ParameterSpecification>();
            variables ??= new Dictionary<string, VariableSpecification>();
            annotations ??= new List<object>();
            runDimensions ??= new Dictionary<string, object>();
            additionalProperties ??= new Dictionary<string, object>();

            return new PipelineResource(
                id,
                name,
                type,
                etag,
                description,
                activities?.ToList(),
                parameters,
                variables,
                concurrency,
                annotations?.ToList(),
                runDimensions,
                folder,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CreateRunResponse"/>. </summary>
        /// <param name="runId"> Identifier of a run. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="runId"/> is null. </exception>
        /// <returns> A new <see cref="Models.CreateRunResponse"/> instance for mocking. </returns>
        public static CreateRunResponse CreateRunResponse(string runId = null)
        {
            if (runId == null)
            {
                throw new ArgumentNullException(nameof(runId));
            }

            return new CreateRunResponse(runId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PipelineRunsQueryResponse"/>. </summary>
        /// <param name="value"> List of pipeline runs. </param>
        /// <param name="continuationToken"> The continuation token for getting the next page of results, if any remaining results exist, null otherwise. </param>
        /// <returns> A new <see cref="Models.PipelineRunsQueryResponse"/> instance for mocking. </returns>
        public static PipelineRunsQueryResponse PipelineRunsQueryResponse(IEnumerable<PipelineRun> value = null, string continuationToken = null)
        {
            value ??= new List<PipelineRun>();

            return new PipelineRunsQueryResponse(value?.ToList(), continuationToken);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PipelineRun"/>. </summary>
        /// <param name="runId"> Identifier of a run. </param>
        /// <param name="runGroupId"> Identifier that correlates all the recovery runs of a pipeline run. </param>
        /// <param name="isLatest"> Indicates if the recovered pipeline run is the latest in its group. </param>
        /// <param name="pipelineName"> The pipeline name. </param>
        /// <param name="parameters"> The full or partial list of parameter name, value pair used in the pipeline run. </param>
        /// <param name="invokedBy"> Entity that started the pipeline run. </param>
        /// <param name="lastUpdated"> The last updated timestamp for the pipeline run event in ISO8601 format. </param>
        /// <param name="runStart"> The start time of a pipeline run in ISO8601 format. </param>
        /// <param name="runEnd"> The end time of a pipeline run in ISO8601 format. </param>
        /// <param name="durationInMs"> The duration of a pipeline run. </param>
        /// <param name="status"> The status of a pipeline run. </param>
        /// <param name="message"> The message from a pipeline run. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.PipelineRun"/> instance for mocking. </returns>
        public static PipelineRun PipelineRun(string runId = null, string runGroupId = null, bool? isLatest = null, string pipelineName = null, IReadOnlyDictionary<string, string> parameters = null, PipelineRunInvokedBy invokedBy = null, DateTimeOffset? lastUpdated = null, DateTimeOffset? runStart = null, DateTimeOffset? runEnd = null, int? durationInMs = null, string status = null, string message = null, IReadOnlyDictionary<string, object> additionalProperties = null)
        {
            parameters ??= new Dictionary<string, string>();
            additionalProperties ??= new Dictionary<string, object>();

            return new PipelineRun(
                runId,
                runGroupId,
                isLatest,
                pipelineName,
                parameters,
                invokedBy,
                lastUpdated,
                runStart,
                runEnd,
                durationInMs,
                status,
                message,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PipelineRunInvokedBy"/>. </summary>
        /// <param name="name"> Name of the entity that started the pipeline run. </param>
        /// <param name="id"> The ID of the entity that started the run. </param>
        /// <param name="invokedByType"> The type of the entity that started the run. </param>
        /// <returns> A new <see cref="Models.PipelineRunInvokedBy"/> instance for mocking. </returns>
        public static PipelineRunInvokedBy PipelineRunInvokedBy(string name = null, string id = null, string invokedByType = null)
        {
            return new PipelineRunInvokedBy(name, id, invokedByType);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ActivityRunsQueryResponse"/>. </summary>
        /// <param name="value"> List of activity runs. </param>
        /// <param name="continuationToken"> The continuation token for getting the next page of results, if any remaining results exist, null otherwise. </param>
        /// <returns> A new <see cref="Models.ActivityRunsQueryResponse"/> instance for mocking. </returns>
        public static ActivityRunsQueryResponse ActivityRunsQueryResponse(IEnumerable<ActivityRun> value = null, string continuationToken = null)
        {
            value ??= new List<ActivityRun>();

            return new ActivityRunsQueryResponse(value?.ToList(), continuationToken);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ActivityRun"/>. </summary>
        /// <param name="pipelineName"> The name of the pipeline. </param>
        /// <param name="pipelineRunId"> The id of the pipeline run. </param>
        /// <param name="activityName"> The name of the activity. </param>
        /// <param name="activityType"> The type of the activity. </param>
        /// <param name="activityRunId"> The id of the activity run. </param>
        /// <param name="linkedServiceName"> The name of the compute linked service. </param>
        /// <param name="status"> The status of the activity run. </param>
        /// <param name="activityRunStart"> The start time of the activity run in 'ISO 8601' format. </param>
        /// <param name="activityRunEnd"> The end time of the activity run in 'ISO 8601' format. </param>
        /// <param name="durationInMs"> The duration of the activity run. </param>
        /// <param name="input"> The input for the activity. </param>
        /// <param name="output"> The output for the activity. </param>
        /// <param name="error"> The error if any from the activity run. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.ActivityRun"/> instance for mocking. </returns>
        public static ActivityRun ActivityRun(string pipelineName = null, string pipelineRunId = null, string activityName = null, string activityType = null, string activityRunId = null, string linkedServiceName = null, string status = null, DateTimeOffset? activityRunStart = null, DateTimeOffset? activityRunEnd = null, int? durationInMs = null, object input = null, object output = null, object error = null, IReadOnlyDictionary<string, object> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, object>();

            return new ActivityRun(
                pipelineName,
                pipelineRunId,
                activityName,
                activityType,
                activityRunId,
                linkedServiceName,
                status,
                activityRunStart,
                activityRunEnd,
                durationInMs,
                input,
                output,
                error,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkJobDefinitionResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties"> Properties of spark job definition. </param>
        /// <returns> A new <see cref="Models.SparkJobDefinitionResource"/> instance for mocking. </returns>
        public static SparkJobDefinitionResource SparkJobDefinitionResource(string id = null, string name = null, string type = null, string etag = null, SparkJobDefinition properties = null)
        {
            return new SparkJobDefinitionResource(id, name, type, etag, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkBatchJob"/>. </summary>
        /// <param name="livyInfo"></param>
        /// <param name="name"> The batch name. </param>
        /// <param name="workspaceName"> The workspace name. </param>
        /// <param name="sparkPoolName"> The Spark pool name. </param>
        /// <param name="submitterName"> The submitter name. </param>
        /// <param name="submitterId"> The submitter identifier. </param>
        /// <param name="artifactId"> The artifact identifier. </param>
        /// <param name="jobType"> The job type. </param>
        /// <param name="result"> The Spark batch job result. </param>
        /// <param name="scheduler"> The scheduler information. </param>
        /// <param name="plugin"> The plugin information. </param>
        /// <param name="errors"> The error information. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="id"> The session Id. </param>
        /// <param name="appId"> The application id of this session. </param>
        /// <param name="appInfo"> The detailed application info. </param>
        /// <param name="state"> The batch state. </param>
        /// <param name="logLines"> The log lines. </param>
        /// <returns> A new <see cref="Models.SparkBatchJob"/> instance for mocking. </returns>
        public static SparkBatchJob SparkBatchJob(SparkBatchJobState livyInfo = null, string name = null, string workspaceName = null, string sparkPoolName = null, string submitterName = null, string submitterId = null, string artifactId = null, SparkJobType? jobType = null, SparkBatchJobResultType? result = null, SparkScheduler scheduler = null, SparkServicePlugin plugin = null, IEnumerable<SparkServiceError> errors = null, IReadOnlyDictionary<string, string> tags = null, int id = default, string appId = null, IReadOnlyDictionary<string, string> appInfo = null, LivyStates? state = null, IEnumerable<string> logLines = null)
        {
            errors ??= new List<SparkServiceError>();
            tags ??= new Dictionary<string, string>();
            appInfo ??= new Dictionary<string, string>();
            logLines ??= new List<string>();

            return new SparkBatchJob(
                livyInfo,
                name,
                workspaceName,
                sparkPoolName,
                submitterName,
                submitterId,
                artifactId,
                jobType,
                result,
                scheduler,
                plugin,
                errors?.ToList(),
                tags,
                id,
                appId,
                appInfo,
                state,
                logLines?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkBatchJobState"/>. </summary>
        /// <param name="notStartedAt"> the time that at which "not_started" livy state was first seen. </param>
        /// <param name="startingAt"> the time that at which "starting" livy state was first seen. </param>
        /// <param name="runningAt"> the time that at which "running" livy state was first seen. </param>
        /// <param name="deadAt"> time that at which "dead" livy state was first seen. </param>
        /// <param name="successAt"> the time that at which "success" livy state was first seen. </param>
        /// <param name="terminatedAt"> the time that at which "killed" livy state was first seen. </param>
        /// <param name="recoveringAt"> the time that at which "recovering" livy state was first seen. </param>
        /// <param name="currentState"> the Spark job state. </param>
        /// <param name="jobCreationRequest"></param>
        /// <returns> A new <see cref="Models.SparkBatchJobState"/> instance for mocking. </returns>
        public static SparkBatchJobState SparkBatchJobState(DateTimeOffset? notStartedAt = null, DateTimeOffset? startingAt = null, DateTimeOffset? runningAt = null, DateTimeOffset? deadAt = null, DateTimeOffset? successAt = null, DateTimeOffset? terminatedAt = null, DateTimeOffset? recoveringAt = null, string currentState = null, SparkRequest jobCreationRequest = null)
        {
            return new SparkBatchJobState(
                notStartedAt,
                startingAt,
                runningAt,
                deadAt,
                successAt,
                terminatedAt,
                recoveringAt,
                currentState,
                jobCreationRequest);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkRequest"/>. </summary>
        /// <param name="name"></param>
        /// <param name="file"></param>
        /// <param name="className"></param>
        /// <param name="arguments"></param>
        /// <param name="jars"></param>
        /// <param name="pythonFiles"></param>
        /// <param name="files"></param>
        /// <param name="archives"></param>
        /// <param name="configuration"> Dictionary of &lt;string&gt;. </param>
        /// <param name="driverMemory"></param>
        /// <param name="driverCores"></param>
        /// <param name="executorMemory"></param>
        /// <param name="executorCores"></param>
        /// <param name="executorCount"></param>
        /// <returns> A new <see cref="Models.SparkRequest"/> instance for mocking. </returns>
        public static SparkRequest SparkRequest(string name = null, string file = null, string className = null, IEnumerable<string> arguments = null, IEnumerable<string> jars = null, IEnumerable<string> pythonFiles = null, IEnumerable<string> files = null, IEnumerable<string> archives = null, IReadOnlyDictionary<string, string> configuration = null, string driverMemory = null, int? driverCores = null, string executorMemory = null, int? executorCores = null, int? executorCount = null)
        {
            arguments ??= new List<string>();
            jars ??= new List<string>();
            pythonFiles ??= new List<string>();
            files ??= new List<string>();
            archives ??= new List<string>();
            configuration ??= new Dictionary<string, string>();

            return new SparkRequest(
                name,
                file,
                className,
                arguments?.ToList(),
                jars?.ToList(),
                pythonFiles?.ToList(),
                files?.ToList(),
                archives?.ToList(),
                configuration,
                driverMemory,
                driverCores,
                executorMemory,
                executorCores,
                executorCount);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkScheduler"/>. </summary>
        /// <param name="submittedAt"></param>
        /// <param name="scheduledAt"></param>
        /// <param name="endedAt"></param>
        /// <param name="cancellationRequestedAt"></param>
        /// <param name="currentState"></param>
        /// <returns> A new <see cref="Models.SparkScheduler"/> instance for mocking. </returns>
        public static SparkScheduler SparkScheduler(DateTimeOffset? submittedAt = null, DateTimeOffset? scheduledAt = null, DateTimeOffset? endedAt = null, DateTimeOffset? cancellationRequestedAt = null, SchedulerCurrentState? currentState = null)
        {
            return new SparkScheduler(submittedAt, scheduledAt, endedAt, cancellationRequestedAt, currentState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkServicePlugin"/>. </summary>
        /// <param name="preparationStartedAt"></param>
        /// <param name="resourceAcquisitionStartedAt"></param>
        /// <param name="submissionStartedAt"></param>
        /// <param name="monitoringStartedAt"></param>
        /// <param name="cleanupStartedAt"></param>
        /// <param name="currentState"></param>
        /// <returns> A new <see cref="Models.SparkServicePlugin"/> instance for mocking. </returns>
        public static SparkServicePlugin SparkServicePlugin(DateTimeOffset? preparationStartedAt = null, DateTimeOffset? resourceAcquisitionStartedAt = null, DateTimeOffset? submissionStartedAt = null, DateTimeOffset? monitoringStartedAt = null, DateTimeOffset? cleanupStartedAt = null, PluginCurrentState? currentState = null)
        {
            return new SparkServicePlugin(
                preparationStartedAt,
                resourceAcquisitionStartedAt,
                submissionStartedAt,
                monitoringStartedAt,
                cleanupStartedAt,
                currentState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SparkServiceError"/>. </summary>
        /// <param name="message"></param>
        /// <param name="errorCode"></param>
        /// <param name="source"></param>
        /// <returns> A new <see cref="Models.SparkServiceError"/> instance for mocking. </returns>
        public static SparkServiceError SparkServiceError(string message = null, string errorCode = null, SparkErrorSource? source = null)
        {
            return new SparkServiceError(message, errorCode, source);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlPoolInfoListResult"/>. </summary>
        /// <param name="nextLink"> Link to the next page of results. </param>
        /// <param name="value"> List of SQL pools. </param>
        /// <returns> A new <see cref="Models.SqlPoolInfoListResult"/> instance for mocking. </returns>
        public static SqlPoolInfoListResult SqlPoolInfoListResult(string nextLink = null, IEnumerable<SqlPool> value = null)
        {
            value ??= new List<SqlPool>();

            return new SqlPoolInfoListResult(nextLink, value?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlPool"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="sku"> SQL pool SKU. </param>
        /// <param name="maxSizeBytes"> Maximum size in bytes. </param>
        /// <param name="collation"> Collation mode. </param>
        /// <param name="sourceDatabaseId"> Source database to create from. </param>
        /// <param name="recoverableDatabaseId"> Backup database to restore from. </param>
        /// <param name="provisioningState"> Resource state. </param>
        /// <param name="status"> Resource status. </param>
        /// <param name="restorePointInTime"> Snapshot time to restore. </param>
        /// <param name="createMode">
        /// Specifies the mode of sql pool creation.
        ///
        /// Default: regular sql pool creation.
        ///
        /// PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must be specified as the resource ID of the existing sql pool, and restorePointInTime must be specified.
        ///
        /// Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId  must be specified as the recoverableDatabaseId to restore.
        ///
        /// Restore: Creates a sql pool by restoring a backup of a deleted sql  pool. SourceDatabaseId should be the sql pool's original resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be specified.
        /// </param>
        /// <param name="creationDate"> Date the SQL pool was created. </param>
        /// <returns> A new <see cref="Models.SqlPool"/> instance for mocking. </returns>
        public static SqlPool SqlPool(string id = null, string name = null, string type = null, IDictionary<string, string> tags = null, string location = null, Sku sku = null, long? maxSizeBytes = null, string collation = null, string sourceDatabaseId = null, string recoverableDatabaseId = null, string provisioningState = null, string status = null, string restorePointInTime = null, CreateMode? createMode = null, DateTimeOffset? creationDate = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SqlPool(
                id,
                name,
                type,
                tags,
                location,
                sku,
                maxSizeBytes,
                collation,
                sourceDatabaseId,
                recoverableDatabaseId,
                provisioningState,
                status,
                restorePointInTime,
                createMode,
                creationDate);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlScriptResource"/>. </summary>
        /// <param name="id"> Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts. </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties"> Properties of sql script. </param>
        /// <returns> A new <see cref="Models.SqlScriptResource"/> instance for mocking. </returns>
        public static SqlScriptResource SqlScriptResource(string id = null, string name = null, string type = null, string etag = null, SqlScript properties = null)
        {
            return new SqlScriptResource(id, name, type, etag, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TriggerResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties">
        /// Properties of the trigger.
        /// Please note <see cref="Models.Trigger"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.BlobEventsTrigger"/>, <see cref="Models.BlobTrigger"/>, <see cref="Models.ChainingTrigger"/>, <see cref="Models.CustomEventsTrigger"/>, <see cref="Models.MultiplePipelineTrigger"/>, <see cref="Models.RerunTumblingWindowTrigger"/>, <see cref="Models.ScheduleTrigger"/> and <see cref="Models.TumblingWindowTrigger"/>.
        /// </param>
        /// <returns> A new <see cref="Models.TriggerResource"/> instance for mocking. </returns>
        public static TriggerResource TriggerResource(string id = null, string name = null, string type = null, string etag = null, Trigger properties = null)
        {
            return new TriggerResource(id, name, type, etag, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.Trigger"/>. </summary>
        /// <param name="type"> Trigger type. </param>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.Trigger"/> instance for mocking. </returns>
        public static Trigger Trigger(string type = null, string description = null, TriggerRuntimeState? runtimeState = null, IEnumerable<object> annotations = null, IDictionary<string, object> additionalProperties = null)
        {
            annotations ??= new List<object>();
            additionalProperties ??= new Dictionary<string, object>();

            return new UnknownTrigger(type, description, runtimeState, annotations?.ToList(), additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TriggerSubscriptionOperationStatus"/>. </summary>
        /// <param name="triggerName"> Trigger name. </param>
        /// <param name="status"> Event Subscription Status. </param>
        /// <returns> A new <see cref="Models.TriggerSubscriptionOperationStatus"/> instance for mocking. </returns>
        public static TriggerSubscriptionOperationStatus TriggerSubscriptionOperationStatus(string triggerName = null, EventSubscriptionStatus? status = null)
        {
            return new TriggerSubscriptionOperationStatus(triggerName, status);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TriggerRunsQueryResponse"/>. </summary>
        /// <param name="value"> List of trigger runs. </param>
        /// <param name="continuationToken"> The continuation token for getting the next page of results, if any remaining results exist, null otherwise. </param>
        /// <returns> A new <see cref="Models.TriggerRunsQueryResponse"/> instance for mocking. </returns>
        public static TriggerRunsQueryResponse TriggerRunsQueryResponse(IEnumerable<TriggerRun> value = null, string continuationToken = null)
        {
            value ??= new List<TriggerRun>();

            return new TriggerRunsQueryResponse(value?.ToList(), continuationToken);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TriggerRun"/>. </summary>
        /// <param name="triggerRunId"> Trigger run id. </param>
        /// <param name="triggerName"> Trigger name. </param>
        /// <param name="triggerType"> Trigger type. </param>
        /// <param name="triggerRunTimestamp"> Trigger run start time. </param>
        /// <param name="status"> Trigger run status. </param>
        /// <param name="message"> Trigger error message. </param>
        /// <param name="properties"> List of property name and value related to trigger run. Name, value pair depends on type of trigger. </param>
        /// <param name="triggeredPipelines"> List of pipeline name and run Id triggered by the trigger run. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.TriggerRun"/> instance for mocking. </returns>
        public static TriggerRun TriggerRun(string triggerRunId = null, string triggerName = null, string triggerType = null, DateTimeOffset? triggerRunTimestamp = null, TriggerRunStatus? status = null, string message = null, IReadOnlyDictionary<string, string> properties = null, IReadOnlyDictionary<string, string> triggeredPipelines = null, IReadOnlyDictionary<string, object> additionalProperties = null)
        {
            properties ??= new Dictionary<string, string>();
            triggeredPipelines ??= new Dictionary<string, string>();
            additionalProperties ??= new Dictionary<string, object>();

            return new TriggerRun(
                triggerRunId,
                triggerName,
                triggerType,
                triggerRunTimestamp,
                status,
                message,
                properties,
                triggeredPipelines,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.Workspace"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="identity"> Identity of the workspace. </param>
        /// <param name="defaultDataLakeStorage"> Workspace default data lake storage account details. </param>
        /// <param name="sqlAdministratorLoginPassword"> SQL administrator login password. </param>
        /// <param name="managedResourceGroupName"> Workspace managed resource group. The resource group name uniquely identifies the resource group within the user subscriptionId. The resource group name must be no longer than 90 characters long, and must be alphanumeric characters (Char.IsLetterOrDigit()) and '-', '_', '(', ')' and'.'. Note that the name cannot end with '.'. </param>
        /// <param name="provisioningState"> Resource provisioning state. </param>
        /// <param name="sqlAdministratorLogin"> Login for workspace SQL active directory administrator. </param>
        /// <param name="virtualNetworkProfile"> Virtual Network profile. </param>
        /// <param name="connectivityEndpoints"> Connectivity endpoints. </param>
        /// <param name="managedVirtualNetwork"> Setting this to 'default' will ensure that all compute for this workspace is in a virtual network managed on behalf of the user. </param>
        /// <param name="privateEndpointConnections"> Private endpoint connections to the workspace. </param>
        /// <param name="encryption"> The encryption details of the workspace. </param>
        /// <param name="workspaceUID"> The workspace unique identifier. </param>
        /// <param name="extraProperties"> Workspace level configs and feature flags. </param>
        /// <param name="managedVirtualNetworkSettings"> Managed Virtual Network Settings. </param>
        /// <param name="workspaceRepositoryConfiguration"> Git integration settings. </param>
        /// <param name="purviewConfiguration"> Purview Configuration. </param>
        /// <param name="adlaResourceId"> The ADLA resource ID. </param>
        /// <returns> A new <see cref="Models.Workspace"/> instance for mocking. </returns>
        public static Workspace Workspace(string id = null, string name = null, string type = null, IDictionary<string, string> tags = null, string location = null, ManagedIdentity identity = null, DataLakeStorageAccountDetails defaultDataLakeStorage = null, string sqlAdministratorLoginPassword = null, string managedResourceGroupName = null, string provisioningState = null, string sqlAdministratorLogin = null, VirtualNetworkProfile virtualNetworkProfile = null, IDictionary<string, string> connectivityEndpoints = null, string managedVirtualNetwork = null, IEnumerable<PrivateEndpointConnection> privateEndpointConnections = null, EncryptionDetails encryption = null, Guid? workspaceUID = null, IReadOnlyDictionary<string, object> extraProperties = null, ManagedVirtualNetworkSettings managedVirtualNetworkSettings = null, WorkspaceRepositoryConfiguration workspaceRepositoryConfiguration = null, PurviewConfiguration purviewConfiguration = null, string adlaResourceId = null)
        {
            tags ??= new Dictionary<string, string>();
            connectivityEndpoints ??= new Dictionary<string, string>();
            privateEndpointConnections ??= new List<PrivateEndpointConnection>();
            extraProperties ??= new Dictionary<string, object>();

            return new Workspace(
                id,
                name,
                type,
                tags,
                location,
                identity,
                defaultDataLakeStorage,
                sqlAdministratorLoginPassword,
                managedResourceGroupName,
                provisioningState,
                sqlAdministratorLogin,
                virtualNetworkProfile,
                connectivityEndpoints,
                managedVirtualNetwork,
                privateEndpointConnections?.ToList(),
                encryption,
                workspaceUID,
                extraProperties,
                managedVirtualNetworkSettings,
                workspaceRepositoryConfiguration,
                purviewConfiguration,
                adlaResourceId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrivateEndpointConnection"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="privateEndpoint"> The private endpoint which the connection belongs to. </param>
        /// <param name="connectionState"> Connection state of the private endpoint connection. </param>
        /// <param name="provisioningState"> Provisioning state of the private endpoint connection. </param>
        /// <returns> A new <see cref="Models.PrivateEndpointConnection"/> instance for mocking. </returns>
        public static PrivateEndpointConnection PrivateEndpointConnection(string id = null, string name = null, string type = null, PrivateEndpoint privateEndpoint = null, PrivateLinkServiceConnectionState connectionState = null, string provisioningState = null)
        {
            return new PrivateEndpointConnection(
                id,
                name,
                type,
                privateEndpoint,
                connectionState,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrivateEndpoint"/>. </summary>
        /// <param name="id"> Resource id of the private endpoint. </param>
        /// <returns> A new <see cref="Models.PrivateEndpoint"/> instance for mocking. </returns>
        public static PrivateEndpoint PrivateEndpoint(string id = null)
        {
            return new PrivateEndpoint(id);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrivateLinkServiceConnectionState"/>. </summary>
        /// <param name="status"> The private link service connection status. </param>
        /// <param name="description"> The private link service connection description. </param>
        /// <param name="actionsRequired"> The actions required for private link service connection. </param>
        /// <returns> A new <see cref="Models.PrivateLinkServiceConnectionState"/> instance for mocking. </returns>
        public static PrivateLinkServiceConnectionState PrivateLinkServiceConnectionState(string status = null, string description = null, string actionsRequired = null)
        {
            return new PrivateLinkServiceConnectionState(status, description, actionsRequired);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProxyResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <returns> A new <see cref="Models.ProxyResource"/> instance for mocking. </returns>
        public static ProxyResource ProxyResource(string id = null, string name = null, string type = null)
        {
            return new ProxyResource(id, name, type);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EncryptionDetails"/>. </summary>
        /// <param name="doubleEncryptionEnabled"> Double Encryption enabled. </param>
        /// <param name="cmk"> Customer Managed Key Details. </param>
        /// <returns> A new <see cref="Models.EncryptionDetails"/> instance for mocking. </returns>
        public static EncryptionDetails EncryptionDetails(bool? doubleEncryptionEnabled = null, CustomerManagedKeyDetails cmk = null)
        {
            return new EncryptionDetails(doubleEncryptionEnabled, cmk);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CustomerManagedKeyDetails"/>. </summary>
        /// <param name="status"> The customer managed key status on the workspace. </param>
        /// <param name="key"> The key object of the workspace. </param>
        /// <returns> A new <see cref="Models.CustomerManagedKeyDetails"/> instance for mocking. </returns>
        public static CustomerManagedKeyDetails CustomerManagedKeyDetails(string status = null, WorkspaceKeyDetails key = null)
        {
            return new CustomerManagedKeyDetails(status, key);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedIdentity"/>. </summary>
        /// <param name="principalId"> The principal ID of the workspace managed identity. </param>
        /// <param name="tenantId"> The tenant ID of the workspace managed identity. </param>
        /// <param name="type"> The type of managed identity for the workspace. </param>
        /// <returns> A new <see cref="Models.ManagedIdentity"/> instance for mocking. </returns>
        public static ManagedIdentity ManagedIdentity(string principalId = null, Guid? tenantId = null, ResourceIdentityType? type = null)
        {
            return new ManagedIdentity(principalId, tenantId, type);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WorkspaceIdentity"/>. </summary>
        /// <param name="type"> The identity type. Currently the only supported type is 'SystemAssigned'. </param>
        /// <param name="principalId"> The principal id of the identity. </param>
        /// <param name="tenantId"> The client tenant id of the identity. </param>
        /// <returns> A new <see cref="Models.WorkspaceIdentity"/> instance for mocking. </returns>
        public static WorkspaceIdentity WorkspaceIdentity(WorkspaceIdentityType type = default, string principalId = null, string tenantId = null)
        {
            return new WorkspaceIdentity(type, principalId, tenantId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExposureControlResponse"/>. </summary>
        /// <param name="featureName"> The feature name. </param>
        /// <param name="value"> The feature value. </param>
        /// <returns> A new <see cref="Models.ExposureControlResponse"/> instance for mocking. </returns>
        public static ExposureControlResponse ExposureControlResponse(string featureName = null, string value = null)
        {
            return new ExposureControlResponse(featureName, value);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RerunTriggerListResponse"/>. </summary>
        /// <param name="value"> List of rerun triggers. </param>
        /// <param name="nextLink"> The continuation token for getting the next page of results, if any remaining results exist, null otherwise. </param>
        /// <returns> A new <see cref="Models.RerunTriggerListResponse"/> instance for mocking. </returns>
        public static RerunTriggerListResponse RerunTriggerListResponse(IEnumerable<RerunTriggerResource> value = null, string nextLink = null)
        {
            value ??= new List<RerunTriggerResource>();

            return new RerunTriggerListResponse(value?.ToList(), nextLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RerunTriggerResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties"> Properties of the rerun trigger. </param>
        /// <returns> A new <see cref="Models.RerunTriggerResource"/> instance for mocking. </returns>
        public static RerunTriggerResource RerunTriggerResource(string id = null, string name = null, string type = null, string etag = null, RerunTumblingWindowTrigger properties = null)
        {
            return new RerunTriggerResource(id, name, type, etag, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RerunTumblingWindowTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="parentTrigger"> The parent trigger reference. </param>
        /// <param name="requestedStartTime"> The start time for the time period for which restatement is initiated. Only UTC time is currently supported. </param>
        /// <param name="requestedEndTime"> The end time for the time period for which restatement is initiated. Only UTC time is currently supported. </param>
        /// <param name="rerunConcurrency"> The max number of parallel time windows (ready for execution) for which a rerun is triggered. </param>
        /// <returns> A new <see cref="Models.RerunTumblingWindowTrigger"/> instance for mocking. </returns>
        public static RerunTumblingWindowTrigger RerunTumblingWindowTrigger(string description = null, TriggerRuntimeState? runtimeState = null, IEnumerable<object> annotations = null, IDictionary<string, object> additionalProperties = null, object parentTrigger = null, DateTimeOffset requestedStartTime = default, DateTimeOffset requestedEndTime = default, int rerunConcurrency = default)
        {
            annotations ??= new List<object>();
            additionalProperties ??= new Dictionary<string, object>();

            return new RerunTumblingWindowTrigger(
                "RerunTumblingWindowTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                parentTrigger,
                requestedStartTime,
                requestedEndTime,
                rerunConcurrency);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MultiplePipelineTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipelines"> Pipelines that need to be started. </param>
        /// <returns> A new <see cref="Models.MultiplePipelineTrigger"/> instance for mocking. </returns>
        public static MultiplePipelineTrigger MultiplePipelineTrigger(string description = null, TriggerRuntimeState? runtimeState = null, IEnumerable<object> annotations = null, IDictionary<string, object> additionalProperties = null, IEnumerable<TriggerPipelineReference> pipelines = null)
        {
            annotations ??= new List<object>();
            additionalProperties ??= new Dictionary<string, object>();
            pipelines ??= new List<TriggerPipelineReference>();

            return new MultiplePipelineTrigger(
                "MultiplePipelineTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipelines?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ScheduleTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipelines"> Pipelines that need to be started. </param>
        /// <param name="recurrence"> Recurrence schedule configuration. </param>
        /// <returns> A new <see cref="Models.ScheduleTrigger"/> instance for mocking. </returns>
        public static ScheduleTrigger ScheduleTrigger(string description = null, TriggerRuntimeState? runtimeState = null, IEnumerable<object> annotations = null, IDictionary<string, object> additionalProperties = null, IEnumerable<TriggerPipelineReference> pipelines = null, ScheduleTriggerRecurrence recurrence = null)
        {
            annotations ??= new List<object>();
            additionalProperties ??= new Dictionary<string, object>();
            pipelines ??= new List<TriggerPipelineReference>();

            return new ScheduleTrigger(
                "ScheduleTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipelines?.ToList(),
                recurrence);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BlobTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipelines"> Pipelines that need to be started. </param>
        /// <param name="folderPath"> The path of the container/folder that will trigger the pipeline. </param>
        /// <param name="maxConcurrency"> The max number of parallel files to handle when it is triggered. </param>
        /// <param name="linkedService"> The Azure Storage linked service reference. </param>
        /// <returns> A new <see cref="Models.BlobTrigger"/> instance for mocking. </returns>
        public static BlobTrigger BlobTrigger(string description = null, TriggerRuntimeState? runtimeState = null, IEnumerable<object> annotations = null, IDictionary<string, object> additionalProperties = null, IEnumerable<TriggerPipelineReference> pipelines = null, string folderPath = null, int maxConcurrency = default, LinkedServiceReference linkedService = null)
        {
            annotations ??= new List<object>();
            additionalProperties ??= new Dictionary<string, object>();
            pipelines ??= new List<TriggerPipelineReference>();

            return new BlobTrigger(
                "BlobTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipelines?.ToList(),
                folderPath,
                maxConcurrency,
                linkedService);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BlobEventsTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipelines"> Pipelines that need to be started. </param>
        /// <param name="blobPathBeginsWith"> The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith. </param>
        /// <param name="blobPathEndsWith"> The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith. </param>
        /// <param name="ignoreEmptyBlobs"> If set to true, blobs with zero bytes will be ignored. </param>
        /// <param name="events"> The type of events that cause this trigger to fire. </param>
        /// <param name="scope"> The ARM resource ID of the Storage Account. </param>
        /// <returns> A new <see cref="Models.BlobEventsTrigger"/> instance for mocking. </returns>
        public static BlobEventsTrigger BlobEventsTrigger(string description = null, TriggerRuntimeState? runtimeState = null, IEnumerable<object> annotations = null, IDictionary<string, object> additionalProperties = null, IEnumerable<TriggerPipelineReference> pipelines = null, string blobPathBeginsWith = null, string blobPathEndsWith = null, bool? ignoreEmptyBlobs = null, IEnumerable<BlobEventType> events = null, string scope = null)
        {
            annotations ??= new List<object>();
            additionalProperties ??= new Dictionary<string, object>();
            pipelines ??= new List<TriggerPipelineReference>();
            events ??= new List<BlobEventType>();

            return new BlobEventsTrigger(
                "BlobEventsTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipelines?.ToList(),
                blobPathBeginsWith,
                blobPathEndsWith,
                ignoreEmptyBlobs,
                events?.ToList(),
                scope);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CustomEventsTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipelines"> Pipelines that need to be started. </param>
        /// <param name="subjectBeginsWith"> The event subject must begin with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith. </param>
        /// <param name="subjectEndsWith"> The event subject must end with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith. </param>
        /// <param name="events"> The list of event types that cause this trigger to fire. </param>
        /// <param name="scope"> The ARM resource ID of the Azure Event Grid Topic. </param>
        /// <returns> A new <see cref="Models.CustomEventsTrigger"/> instance for mocking. </returns>
        public static CustomEventsTrigger CustomEventsTrigger(string description = null, TriggerRuntimeState? runtimeState = null, IEnumerable<object> annotations = null, IDictionary<string, object> additionalProperties = null, IEnumerable<TriggerPipelineReference> pipelines = null, string subjectBeginsWith = null, string subjectEndsWith = null, IEnumerable<object> events = null, string scope = null)
        {
            annotations ??= new List<object>();
            additionalProperties ??= new Dictionary<string, object>();
            pipelines ??= new List<TriggerPipelineReference>();
            events ??= new List<object>();

            return new CustomEventsTrigger(
                "CustomEventsTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipelines?.ToList(),
                subjectBeginsWith,
                subjectEndsWith,
                events?.ToList(),
                scope);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TumblingWindowTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipeline"> Pipeline for which runs are created when an event is fired for trigger window that is ready. </param>
        /// <param name="frequency"> The frequency of the time windows. </param>
        /// <param name="interval"> The interval of the time windows. The minimum interval allowed is 15 Minutes. </param>
        /// <param name="startTime"> The start time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported. </param>
        /// <param name="endTime"> The end time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported. </param>
        /// <param name="delay"> Specifies how long the trigger waits past due time before triggering new run. It doesn't alter window start and end time. The default is 0. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="maxConcurrency"> The max number of parallel time windows (ready for execution) for which a new run is triggered. </param>
        /// <param name="retryPolicy"> Retry policy that will be applied for failed pipeline runs. </param>
        /// <param name="dependsOn">
        /// Triggers that this trigger depends on. Only tumbling window triggers are supported.
        /// Please note <see cref="DependencyReference"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="SelfDependencyTumblingWindowTriggerReference"/>, <see cref="TriggerDependencyReference"/> and <see cref="TumblingWindowTriggerDependencyReference"/>.
        /// </param>
        /// <returns> A new <see cref="Models.TumblingWindowTrigger"/> instance for mocking. </returns>
        public static TumblingWindowTrigger TumblingWindowTrigger(string description = null, TriggerRuntimeState? runtimeState = null, IEnumerable<object> annotations = null, IDictionary<string, object> additionalProperties = null, TriggerPipelineReference pipeline = null, TumblingWindowFrequency frequency = default, int interval = default, DateTimeOffset startTime = default, DateTimeOffset? endTime = null, object delay = null, int maxConcurrency = default, RetryPolicy retryPolicy = null, IEnumerable<DependencyReference> dependsOn = null)
        {
            annotations ??= new List<object>();
            additionalProperties ??= new Dictionary<string, object>();
            dependsOn ??= new List<DependencyReference>();

            return new TumblingWindowTrigger(
                "TumblingWindowTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipeline,
                frequency,
                interval,
                startTime,
                endTime,
                delay,
                maxConcurrency,
                retryPolicy,
                dependsOn?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ChainingTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipeline"> Pipeline for which runs are created when all upstream pipelines complete successfully. </param>
        /// <param name="dependsOn"> Upstream Pipelines. </param>
        /// <param name="runDimension"> Run Dimension property that needs to be emitted by upstream pipelines. </param>
        /// <returns> A new <see cref="Models.ChainingTrigger"/> instance for mocking. </returns>
        public static ChainingTrigger ChainingTrigger(string description = null, TriggerRuntimeState? runtimeState = null, IEnumerable<object> annotations = null, IDictionary<string, object> additionalProperties = null, TriggerPipelineReference pipeline = null, IEnumerable<PipelineReference> dependsOn = null, string runDimension = null)
        {
            annotations ??= new List<object>();
            additionalProperties ??= new Dictionary<string, object>();
            dependsOn ??= new List<PipelineReference>();

            return new ChainingTrigger(
                "ChainingTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipeline,
                dependsOn?.ToList(),
                runDimension);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedIntegrationRuntime"/>. </summary>
        /// <param name="type"> Type of integration runtime. </param>
        /// <param name="description"> Integration runtime description. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="state"> Integration runtime state, only valid for managed dedicated integration runtime. </param>
        /// <param name="managedVirtualNetwork"> Managed Virtual Network reference. </param>
        /// <param name="computeProperties"> The compute resource for managed integration runtime. </param>
        /// <param name="ssisProperties"> SSIS properties for managed integration runtime. </param>
        /// <returns> A new <see cref="Models.ManagedIntegrationRuntime"/> instance for mocking. </returns>
        public static ManagedIntegrationRuntime ManagedIntegrationRuntime(IntegrationRuntimeType type = default, string description = null, IDictionary<string, object> additionalProperties = null, IntegrationRuntimeState? state = null, ManagedVirtualNetworkReference managedVirtualNetwork = null, IntegrationRuntimeComputeProperties computeProperties = null, IntegrationRuntimeSsisProperties ssisProperties = null)
        {
            additionalProperties ??= new Dictionary<string, object>();

            return new ManagedIntegrationRuntime(
                type,
                description,
                additionalProperties,
                state,
                managedVirtualNetwork,
                computeProperties,
                ssisProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedVirtualNetworkReference"/>. </summary>
        /// <param name="type"> Managed Virtual Network reference type. </param>
        /// <param name="referenceName"> Reference ManagedVirtualNetwork name. </param>
        /// <returns> A new <see cref="Models.ManagedVirtualNetworkReference"/> instance for mocking. </returns>
        public static ManagedVirtualNetworkReference ManagedVirtualNetworkReference(ManagedVirtualNetworkReferenceType type = default, string referenceName = null)
        {
            return new ManagedVirtualNetworkReference(type, referenceName);
        }
    }
}
