// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Synapse.AccessControl.Samples
{
    public partial class Samples_RoleDefinitionsClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetRoleDefinitions_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            RoleDefinitionsClient client = new RoleDefinitionsClient(endpoint, credential);

            Response response = client.GetRoleDefinitions(null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetRoleDefinitions_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            RoleDefinitionsClient client = new RoleDefinitionsClient(endpoint, credential);

            Response response = await client.GetRoleDefinitionsAsync(null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetRoleDefinitions_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            RoleDefinitionsClient client = new RoleDefinitionsClient(endpoint, credential);

            Response response = client.GetRoleDefinitions(true, "<scope>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("isBuiltIn").ToString());
            Console.WriteLine(result[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("permissions")[0].GetProperty("actions")[0].ToString());
            Console.WriteLine(result[0].GetProperty("permissions")[0].GetProperty("notActions")[0].ToString());
            Console.WriteLine(result[0].GetProperty("permissions")[0].GetProperty("dataActions")[0].ToString());
            Console.WriteLine(result[0].GetProperty("permissions")[0].GetProperty("notDataActions")[0].ToString());
            Console.WriteLine(result[0].GetProperty("scopes")[0].ToString());
            Console.WriteLine(result[0].GetProperty("availabilityStatus").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetRoleDefinitions_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            RoleDefinitionsClient client = new RoleDefinitionsClient(endpoint, credential);

            Response response = await client.GetRoleDefinitionsAsync(true, "<scope>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("isBuiltIn").ToString());
            Console.WriteLine(result[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("permissions")[0].GetProperty("actions")[0].ToString());
            Console.WriteLine(result[0].GetProperty("permissions")[0].GetProperty("notActions")[0].ToString());
            Console.WriteLine(result[0].GetProperty("permissions")[0].GetProperty("dataActions")[0].ToString());
            Console.WriteLine(result[0].GetProperty("permissions")[0].GetProperty("notDataActions")[0].ToString());
            Console.WriteLine(result[0].GetProperty("scopes")[0].ToString());
            Console.WriteLine(result[0].GetProperty("availabilityStatus").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetRoleDefinitionById_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            RoleDefinitionsClient client = new RoleDefinitionsClient(endpoint, credential);

            Response response = client.GetRoleDefinitionById("<roleDefinitionId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetRoleDefinitionById_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            RoleDefinitionsClient client = new RoleDefinitionsClient(endpoint, credential);

            Response response = await client.GetRoleDefinitionByIdAsync("<roleDefinitionId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetRoleDefinitionById_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            RoleDefinitionsClient client = new RoleDefinitionsClient(endpoint, credential);

            Response response = client.GetRoleDefinitionById("<roleDefinitionId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isBuiltIn").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("permissions")[0].GetProperty("actions")[0].ToString());
            Console.WriteLine(result.GetProperty("permissions")[0].GetProperty("notActions")[0].ToString());
            Console.WriteLine(result.GetProperty("permissions")[0].GetProperty("dataActions")[0].ToString());
            Console.WriteLine(result.GetProperty("permissions")[0].GetProperty("notDataActions")[0].ToString());
            Console.WriteLine(result.GetProperty("scopes")[0].ToString());
            Console.WriteLine(result.GetProperty("availabilityStatus").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetRoleDefinitionById_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            RoleDefinitionsClient client = new RoleDefinitionsClient(endpoint, credential);

            Response response = await client.GetRoleDefinitionByIdAsync("<roleDefinitionId>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isBuiltIn").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("permissions")[0].GetProperty("actions")[0].ToString());
            Console.WriteLine(result.GetProperty("permissions")[0].GetProperty("notActions")[0].ToString());
            Console.WriteLine(result.GetProperty("permissions")[0].GetProperty("dataActions")[0].ToString());
            Console.WriteLine(result.GetProperty("permissions")[0].GetProperty("notDataActions")[0].ToString());
            Console.WriteLine(result.GetProperty("scopes")[0].ToString());
            Console.WriteLine(result.GetProperty("availabilityStatus").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetScopes_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            RoleDefinitionsClient client = new RoleDefinitionsClient(endpoint, credential);

            Response response = client.GetScopes(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetScopes_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            RoleDefinitionsClient client = new RoleDefinitionsClient(endpoint, credential);

            Response response = await client.GetScopesAsync(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetScopes_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            RoleDefinitionsClient client = new RoleDefinitionsClient(endpoint, credential);

            Response response = client.GetScopes(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetScopes_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            RoleDefinitionsClient client = new RoleDefinitionsClient(endpoint, credential);

            Response response = await client.GetScopesAsync(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }
    }
}
