// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Analytics.Synapse.AccessControl;
using Azure.Core.Extensions;

namespace Microsoft.Extensions.Azure
{
    /// <summary> Extension methods to add <see cref="RoleAssignmentsClient"/>, <see cref="RoleDefinitionsClient"/> to client builder. </summary>
    public static partial class AnalyticsSynapseAccessControlClientBuilderExtensions
    {
        /// <summary> Registers a <see cref="RoleAssignmentsClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> The workspace development endpoint, for example https://myworkspace.dev.azuresynapse.net. </param>
        public static IAzureClientBuilder<RoleAssignmentsClient, AccessControlClientOptions> AddRoleAssignmentsClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<RoleAssignmentsClient, AccessControlClientOptions>((options, cred) => new RoleAssignmentsClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="RoleDefinitionsClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> The workspace development endpoint, for example https://myworkspace.dev.azuresynapse.net. </param>
        public static IAzureClientBuilder<RoleDefinitionsClient, AccessControlClientOptions> AddRoleDefinitionsClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<RoleDefinitionsClient, AccessControlClientOptions>((options, cred) => new RoleDefinitionsClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="RoleAssignmentsClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<RoleAssignmentsClient, AccessControlClientOptions> AddRoleAssignmentsClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<RoleAssignmentsClient, AccessControlClientOptions>(configuration);
        }
        /// <summary> Registers a <see cref="RoleDefinitionsClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<RoleDefinitionsClient, AccessControlClientOptions> AddRoleDefinitionsClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<RoleDefinitionsClient, AccessControlClientOptions>(configuration);
        }
    }
}
