// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Support
{
    /// <summary>
    /// A class representing a collection of <see cref="SupportTicketNoSubFileResource"/> and their operations.
    /// Each <see cref="SupportTicketNoSubFileResource"/> in the collection will belong to the same instance of <see cref="TenantFileWorkspaceResource"/>.
    /// To get a <see cref="SupportTicketNoSubFileCollection"/> instance call the GetSupportTicketNoSubFiles method from an instance of <see cref="TenantFileWorkspaceResource"/>.
    /// </summary>
    public partial class SupportTicketNoSubFileCollection : ArmCollection, IEnumerable<SupportTicketNoSubFileResource>, IAsyncEnumerable<SupportTicketNoSubFileResource>
    {
        private readonly ClientDiagnostics _supportTicketNoSubFileFilesNoSubscriptionClientDiagnostics;
        private readonly FilesNoSubscriptionRestOperations _supportTicketNoSubFileFilesNoSubscriptionRestClient;

        /// <summary> Initializes a new instance of the <see cref="SupportTicketNoSubFileCollection"/> class for mocking. </summary>
        protected SupportTicketNoSubFileCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SupportTicketNoSubFileCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SupportTicketNoSubFileCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _supportTicketNoSubFileFilesNoSubscriptionClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Support", SupportTicketNoSubFileResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SupportTicketNoSubFileResource.ResourceType, out string supportTicketNoSubFileFilesNoSubscriptionApiVersion);
            _supportTicketNoSubFileFilesNoSubscriptionRestClient = new FilesNoSubscriptionRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, supportTicketNoSubFileFilesNoSubscriptionApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != "Microsoft.Support/fileWorkspaces")
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, "Microsoft.Support/fileWorkspaces"), nameof(id));
        }

        /// <summary>
        /// Creates a new file under a workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FilesNoSubscription_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="fileName"> File name. </param>
        /// <param name="data"> Create file object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SupportTicketNoSubFileResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string fileName, SupportFileDetailData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _supportTicketNoSubFileFilesNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubFileCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _supportTicketNoSubFileFilesNoSubscriptionRestClient.CreateAsync(Id.Name, fileName, data, cancellationToken).ConfigureAwait(false);
                var uri = _supportTicketNoSubFileFilesNoSubscriptionRestClient.CreateCreateRequestUri(Id.Name, fileName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SupportArmOperation<SupportTicketNoSubFileResource>(Response.FromValue(new SupportTicketNoSubFileResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a new file under a workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FilesNoSubscription_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="fileName"> File name. </param>
        /// <param name="data"> Create file object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SupportTicketNoSubFileResource> CreateOrUpdate(WaitUntil waitUntil, string fileName, SupportFileDetailData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _supportTicketNoSubFileFilesNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubFileCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _supportTicketNoSubFileFilesNoSubscriptionRestClient.Create(Id.Name, fileName, data, cancellationToken);
                var uri = _supportTicketNoSubFileFilesNoSubscriptionRestClient.CreateCreateRequestUri(Id.Name, fileName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SupportArmOperation<SupportTicketNoSubFileResource>(Response.FromValue(new SupportTicketNoSubFileResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns details of a specific file in a work space.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FilesNoSubscription_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fileName"> File Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> is null. </exception>
        public virtual async Task<Response<SupportTicketNoSubFileResource>> GetAsync(string fileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));

            using var scope = _supportTicketNoSubFileFilesNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubFileCollection.Get");
            scope.Start();
            try
            {
                var response = await _supportTicketNoSubFileFilesNoSubscriptionRestClient.GetAsync(Id.Name, fileName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SupportTicketNoSubFileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns details of a specific file in a work space.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FilesNoSubscription_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fileName"> File Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> is null. </exception>
        public virtual Response<SupportTicketNoSubFileResource> Get(string fileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));

            using var scope = _supportTicketNoSubFileFilesNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubFileCollection.Get");
            scope.Start();
            try
            {
                var response = _supportTicketNoSubFileFilesNoSubscriptionRestClient.Get(Id.Name, fileName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SupportTicketNoSubFileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all the Files information under a workspace for an Azure subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FilesNoSubscription_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SupportTicketNoSubFileResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SupportTicketNoSubFileResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _supportTicketNoSubFileFilesNoSubscriptionRestClient.CreateListRequest(Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _supportTicketNoSubFileFilesNoSubscriptionRestClient.CreateListNextPageRequest(nextLink, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SupportTicketNoSubFileResource(Client, SupportFileDetailData.DeserializeSupportFileDetailData(e)), _supportTicketNoSubFileFilesNoSubscriptionClientDiagnostics, Pipeline, "SupportTicketNoSubFileCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all the Files information under a workspace for an Azure subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FilesNoSubscription_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SupportTicketNoSubFileResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SupportTicketNoSubFileResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _supportTicketNoSubFileFilesNoSubscriptionRestClient.CreateListRequest(Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _supportTicketNoSubFileFilesNoSubscriptionRestClient.CreateListNextPageRequest(nextLink, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SupportTicketNoSubFileResource(Client, SupportFileDetailData.DeserializeSupportFileDetailData(e)), _supportTicketNoSubFileFilesNoSubscriptionClientDiagnostics, Pipeline, "SupportTicketNoSubFileCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FilesNoSubscription_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fileName"> File Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string fileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));

            using var scope = _supportTicketNoSubFileFilesNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubFileCollection.Exists");
            scope.Start();
            try
            {
                var response = await _supportTicketNoSubFileFilesNoSubscriptionRestClient.GetAsync(Id.Name, fileName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FilesNoSubscription_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fileName"> File Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> is null. </exception>
        public virtual Response<bool> Exists(string fileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));

            using var scope = _supportTicketNoSubFileFilesNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubFileCollection.Exists");
            scope.Start();
            try
            {
                var response = _supportTicketNoSubFileFilesNoSubscriptionRestClient.Get(Id.Name, fileName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FilesNoSubscription_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fileName"> File Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> is null. </exception>
        public virtual async Task<NullableResponse<SupportTicketNoSubFileResource>> GetIfExistsAsync(string fileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));

            using var scope = _supportTicketNoSubFileFilesNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubFileCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _supportTicketNoSubFileFilesNoSubscriptionRestClient.GetAsync(Id.Name, fileName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SupportTicketNoSubFileResource>(response.GetRawResponse());
                return Response.FromValue(new SupportTicketNoSubFileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FilesNoSubscription_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fileName"> File Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> is null. </exception>
        public virtual NullableResponse<SupportTicketNoSubFileResource> GetIfExists(string fileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));

            using var scope = _supportTicketNoSubFileFilesNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubFileCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _supportTicketNoSubFileFilesNoSubscriptionRestClient.Get(Id.Name, fileName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SupportTicketNoSubFileResource>(response.GetRawResponse());
                return Response.FromValue(new SupportTicketNoSubFileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SupportTicketNoSubFileResource> IEnumerable<SupportTicketNoSubFileResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SupportTicketNoSubFileResource> IAsyncEnumerable<SupportTicketNoSubFileResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
