// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Support
{
    /// <summary>
    /// A class representing a collection of <see cref="SupportTicketNoSubChatTranscriptResource"/> and their operations.
    /// Each <see cref="SupportTicketNoSubChatTranscriptResource"/> in the collection will belong to the same instance of <see cref="TenantSupportTicketResource"/>.
    /// To get a <see cref="SupportTicketNoSubChatTranscriptCollection"/> instance call the GetSupportTicketNoSubChatTranscripts method from an instance of <see cref="TenantSupportTicketResource"/>.
    /// </summary>
    public partial class SupportTicketNoSubChatTranscriptCollection : ArmCollection, IEnumerable<SupportTicketNoSubChatTranscriptResource>, IAsyncEnumerable<SupportTicketNoSubChatTranscriptResource>
    {
        private readonly ClientDiagnostics _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionClientDiagnostics;
        private readonly ChatTranscriptsNoSubscriptionRestOperations _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionRestClient;

        /// <summary> Initializes a new instance of the <see cref="SupportTicketNoSubChatTranscriptCollection"/> class for mocking. </summary>
        protected SupportTicketNoSubChatTranscriptCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SupportTicketNoSubChatTranscriptCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SupportTicketNoSubChatTranscriptCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Support", SupportTicketNoSubChatTranscriptResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SupportTicketNoSubChatTranscriptResource.ResourceType, out string supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionApiVersion);
            _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionRestClient = new ChatTranscriptsNoSubscriptionRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != "Microsoft.Support/supportTickets")
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, "Microsoft.Support/supportTickets"), nameof(id));
        }

        /// <summary>
        /// Returns chatTranscript details for a no subscription support ticket.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/supportTickets/{supportTicketName}/chatTranscripts/{chatTranscriptName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChatTranscriptsNoSubscription_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubChatTranscriptResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="chatTranscriptName"> ChatTranscript name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="chatTranscriptName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="chatTranscriptName"/> is null. </exception>
        public virtual async Task<Response<SupportTicketNoSubChatTranscriptResource>> GetAsync(string chatTranscriptName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(chatTranscriptName, nameof(chatTranscriptName));

            using var scope = _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubChatTranscriptCollection.Get");
            scope.Start();
            try
            {
                var response = await _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionRestClient.GetAsync(Id.Name, chatTranscriptName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SupportTicketNoSubChatTranscriptResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns chatTranscript details for a no subscription support ticket.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/supportTickets/{supportTicketName}/chatTranscripts/{chatTranscriptName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChatTranscriptsNoSubscription_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubChatTranscriptResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="chatTranscriptName"> ChatTranscript name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="chatTranscriptName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="chatTranscriptName"/> is null. </exception>
        public virtual Response<SupportTicketNoSubChatTranscriptResource> Get(string chatTranscriptName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(chatTranscriptName, nameof(chatTranscriptName));

            using var scope = _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubChatTranscriptCollection.Get");
            scope.Start();
            try
            {
                var response = _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionRestClient.Get(Id.Name, chatTranscriptName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SupportTicketNoSubChatTranscriptResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all chat transcripts for a support ticket
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/supportTickets/{supportTicketName}/chatTranscripts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChatTranscriptsNoSubscription_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubChatTranscriptResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SupportTicketNoSubChatTranscriptResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SupportTicketNoSubChatTranscriptResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionRestClient.CreateListRequest(Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionRestClient.CreateListNextPageRequest(nextLink, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SupportTicketNoSubChatTranscriptResource(Client, ChatTranscriptDetailData.DeserializeChatTranscriptDetailData(e)), _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionClientDiagnostics, Pipeline, "SupportTicketNoSubChatTranscriptCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all chat transcripts for a support ticket
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/supportTickets/{supportTicketName}/chatTranscripts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChatTranscriptsNoSubscription_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubChatTranscriptResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SupportTicketNoSubChatTranscriptResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SupportTicketNoSubChatTranscriptResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionRestClient.CreateListRequest(Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionRestClient.CreateListNextPageRequest(nextLink, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SupportTicketNoSubChatTranscriptResource(Client, ChatTranscriptDetailData.DeserializeChatTranscriptDetailData(e)), _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionClientDiagnostics, Pipeline, "SupportTicketNoSubChatTranscriptCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/supportTickets/{supportTicketName}/chatTranscripts/{chatTranscriptName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChatTranscriptsNoSubscription_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubChatTranscriptResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="chatTranscriptName"> ChatTranscript name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="chatTranscriptName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="chatTranscriptName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string chatTranscriptName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(chatTranscriptName, nameof(chatTranscriptName));

            using var scope = _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubChatTranscriptCollection.Exists");
            scope.Start();
            try
            {
                var response = await _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionRestClient.GetAsync(Id.Name, chatTranscriptName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/supportTickets/{supportTicketName}/chatTranscripts/{chatTranscriptName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChatTranscriptsNoSubscription_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubChatTranscriptResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="chatTranscriptName"> ChatTranscript name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="chatTranscriptName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="chatTranscriptName"/> is null. </exception>
        public virtual Response<bool> Exists(string chatTranscriptName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(chatTranscriptName, nameof(chatTranscriptName));

            using var scope = _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubChatTranscriptCollection.Exists");
            scope.Start();
            try
            {
                var response = _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionRestClient.Get(Id.Name, chatTranscriptName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/supportTickets/{supportTicketName}/chatTranscripts/{chatTranscriptName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChatTranscriptsNoSubscription_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubChatTranscriptResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="chatTranscriptName"> ChatTranscript name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="chatTranscriptName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="chatTranscriptName"/> is null. </exception>
        public virtual async Task<NullableResponse<SupportTicketNoSubChatTranscriptResource>> GetIfExistsAsync(string chatTranscriptName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(chatTranscriptName, nameof(chatTranscriptName));

            using var scope = _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubChatTranscriptCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionRestClient.GetAsync(Id.Name, chatTranscriptName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SupportTicketNoSubChatTranscriptResource>(response.GetRawResponse());
                return Response.FromValue(new SupportTicketNoSubChatTranscriptResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Support/supportTickets/{supportTicketName}/chatTranscripts/{chatTranscriptName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChatTranscriptsNoSubscription_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketNoSubChatTranscriptResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="chatTranscriptName"> ChatTranscript name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="chatTranscriptName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="chatTranscriptName"/> is null. </exception>
        public virtual NullableResponse<SupportTicketNoSubChatTranscriptResource> GetIfExists(string chatTranscriptName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(chatTranscriptName, nameof(chatTranscriptName));

            using var scope = _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionClientDiagnostics.CreateScope("SupportTicketNoSubChatTranscriptCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _supportTicketNoSubChatTranscriptChatTranscriptsNoSubscriptionRestClient.Get(Id.Name, chatTranscriptName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SupportTicketNoSubChatTranscriptResource>(response.GetRawResponse());
                return Response.FromValue(new SupportTicketNoSubChatTranscriptResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SupportTicketNoSubChatTranscriptResource> IEnumerable<SupportTicketNoSubChatTranscriptResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SupportTicketNoSubChatTranscriptResource> IAsyncEnumerable<SupportTicketNoSubChatTranscriptResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
