// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Support
{
    /// <summary>
    /// A class representing a collection of <see cref="SupportTicketFileResource"/> and their operations.
    /// Each <see cref="SupportTicketFileResource"/> in the collection will belong to the same instance of <see cref="SubscriptionFileWorkspaceResource"/>.
    /// To get a <see cref="SupportTicketFileCollection"/> instance call the GetSupportTicketFiles method from an instance of <see cref="SubscriptionFileWorkspaceResource"/>.
    /// </summary>
    public partial class SupportTicketFileCollection : ArmCollection, IEnumerable<SupportTicketFileResource>, IAsyncEnumerable<SupportTicketFileResource>
    {
        private readonly ClientDiagnostics _supportTicketFileFilesClientDiagnostics;
        private readonly FilesRestOperations _supportTicketFileFilesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SupportTicketFileCollection"/> class for mocking. </summary>
        protected SupportTicketFileCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SupportTicketFileCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SupportTicketFileCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _supportTicketFileFilesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Support", SupportTicketFileResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SupportTicketFileResource.ResourceType, out string supportTicketFileFilesApiVersion);
            _supportTicketFileFilesRestClient = new FilesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, supportTicketFileFilesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != "Microsoft.Support/fileWorkspaces")
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, "Microsoft.Support/fileWorkspaces"), nameof(id));
        }

        /// <summary>
        /// Creates a new file under a workspace for the specified subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Files_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="fileName"> File name. </param>
        /// <param name="data"> Create file object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SupportTicketFileResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string fileName, SupportFileDetailData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _supportTicketFileFilesClientDiagnostics.CreateScope("SupportTicketFileCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _supportTicketFileFilesRestClient.CreateAsync(Id.SubscriptionId, Id.Name, fileName, data, cancellationToken).ConfigureAwait(false);
                var uri = _supportTicketFileFilesRestClient.CreateCreateRequestUri(Id.SubscriptionId, Id.Name, fileName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SupportArmOperation<SupportTicketFileResource>(Response.FromValue(new SupportTicketFileResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a new file under a workspace for the specified subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Files_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="fileName"> File name. </param>
        /// <param name="data"> Create file object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SupportTicketFileResource> CreateOrUpdate(WaitUntil waitUntil, string fileName, SupportFileDetailData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _supportTicketFileFilesClientDiagnostics.CreateScope("SupportTicketFileCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _supportTicketFileFilesRestClient.Create(Id.SubscriptionId, Id.Name, fileName, data, cancellationToken);
                var uri = _supportTicketFileFilesRestClient.CreateCreateRequestUri(Id.SubscriptionId, Id.Name, fileName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SupportArmOperation<SupportTicketFileResource>(Response.FromValue(new SupportTicketFileResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns details of a specific file in a work space.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Files_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fileName"> File Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> is null. </exception>
        public virtual async Task<Response<SupportTicketFileResource>> GetAsync(string fileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));

            using var scope = _supportTicketFileFilesClientDiagnostics.CreateScope("SupportTicketFileCollection.Get");
            scope.Start();
            try
            {
                var response = await _supportTicketFileFilesRestClient.GetAsync(Id.SubscriptionId, Id.Name, fileName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SupportTicketFileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns details of a specific file in a work space.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Files_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fileName"> File Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> is null. </exception>
        public virtual Response<SupportTicketFileResource> Get(string fileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));

            using var scope = _supportTicketFileFilesClientDiagnostics.CreateScope("SupportTicketFileCollection.Get");
            scope.Start();
            try
            {
                var response = _supportTicketFileFilesRestClient.Get(Id.SubscriptionId, Id.Name, fileName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SupportTicketFileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all the Files information under a workspace for an Azure subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Files_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SupportTicketFileResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SupportTicketFileResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _supportTicketFileFilesRestClient.CreateListRequest(Id.SubscriptionId, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _supportTicketFileFilesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SupportTicketFileResource(Client, SupportFileDetailData.DeserializeSupportFileDetailData(e)), _supportTicketFileFilesClientDiagnostics, Pipeline, "SupportTicketFileCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all the Files information under a workspace for an Azure subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Files_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SupportTicketFileResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SupportTicketFileResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _supportTicketFileFilesRestClient.CreateListRequest(Id.SubscriptionId, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _supportTicketFileFilesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SupportTicketFileResource(Client, SupportFileDetailData.DeserializeSupportFileDetailData(e)), _supportTicketFileFilesClientDiagnostics, Pipeline, "SupportTicketFileCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Files_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fileName"> File Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string fileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));

            using var scope = _supportTicketFileFilesClientDiagnostics.CreateScope("SupportTicketFileCollection.Exists");
            scope.Start();
            try
            {
                var response = await _supportTicketFileFilesRestClient.GetAsync(Id.SubscriptionId, Id.Name, fileName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Files_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fileName"> File Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> is null. </exception>
        public virtual Response<bool> Exists(string fileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));

            using var scope = _supportTicketFileFilesClientDiagnostics.CreateScope("SupportTicketFileCollection.Exists");
            scope.Start();
            try
            {
                var response = _supportTicketFileFilesRestClient.Get(Id.SubscriptionId, Id.Name, fileName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Files_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fileName"> File Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> is null. </exception>
        public virtual async Task<NullableResponse<SupportTicketFileResource>> GetIfExistsAsync(string fileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));

            using var scope = _supportTicketFileFilesClientDiagnostics.CreateScope("SupportTicketFileCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _supportTicketFileFilesRestClient.GetAsync(Id.SubscriptionId, Id.Name, fileName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SupportTicketFileResource>(response.GetRawResponse());
                return Response.FromValue(new SupportTicketFileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Files_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SupportTicketFileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fileName"> File Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fileName"/> is null. </exception>
        public virtual NullableResponse<SupportTicketFileResource> GetIfExists(string fileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fileName, nameof(fileName));

            using var scope = _supportTicketFileFilesClientDiagnostics.CreateScope("SupportTicketFileCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _supportTicketFileFilesRestClient.Get(Id.SubscriptionId, Id.Name, fileName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SupportTicketFileResource>(response.GetRawResponse());
                return Response.FromValue(new SupportTicketFileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SupportTicketFileResource> IEnumerable<SupportTicketFileResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SupportTicketFileResource> IAsyncEnumerable<SupportTicketFileResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
