// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Support.Models;

namespace Azure.ResourceManager.Support
{
    public partial class SupportTicketData : IUtf8JsonSerializable, IJsonModel<SupportTicketData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SupportTicketData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SupportTicketData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SupportTicketData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SupportTicketData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(SupportTicketId))
            {
                writer.WritePropertyName("supportTicketId"u8);
                writer.WriteStringValue(SupportTicketId);
            }
            writer.WritePropertyName("description"u8);
            writer.WriteStringValue(Description);
            writer.WritePropertyName("problemClassificationId"u8);
            writer.WriteStringValue(ProblemClassificationId);
            if (options.Format != "W" && Optional.IsDefined(ProblemClassificationDisplayName))
            {
                writer.WritePropertyName("problemClassificationDisplayName"u8);
                writer.WriteStringValue(ProblemClassificationDisplayName);
            }
            writer.WritePropertyName("severity"u8);
            writer.WriteStringValue(Severity.ToString());
            if (Optional.IsDefined(EnrollmentId))
            {
                writer.WritePropertyName("enrollmentId"u8);
                writer.WriteStringValue(EnrollmentId);
            }
            if (Optional.IsDefined(Require24X7Response))
            {
                writer.WritePropertyName("require24X7Response"u8);
                writer.WriteBooleanValue(Require24X7Response.Value);
            }
            writer.WritePropertyName("advancedDiagnosticConsent"u8);
            writer.WriteStringValue(AdvancedDiagnosticConsent.ToString());
            if (Optional.IsDefined(ProblemScopingQuestions))
            {
                writer.WritePropertyName("problemScopingQuestions"u8);
                writer.WriteStringValue(ProblemScopingQuestions);
            }
            if (Optional.IsDefined(SupportPlanId))
            {
                writer.WritePropertyName("supportPlanId"u8);
                writer.WriteStringValue(SupportPlanId);
            }
            writer.WritePropertyName("contactDetails"u8);
            writer.WriteObjectValue(ContactDetails, options);
            if (Optional.IsDefined(ServiceLevelAgreement))
            {
                writer.WritePropertyName("serviceLevelAgreement"u8);
                writer.WriteObjectValue(ServiceLevelAgreement, options);
            }
            if (Optional.IsDefined(SupportEngineer))
            {
                writer.WritePropertyName("supportEngineer"u8);
                writer.WriteObjectValue(SupportEngineer, options);
            }
            if (options.Format != "W" && Optional.IsDefined(SupportPlanType))
            {
                writer.WritePropertyName("supportPlanType"u8);
                writer.WriteStringValue(SupportPlanType);
            }
            if (options.Format != "W" && Optional.IsDefined(SupportPlanDisplayName))
            {
                writer.WritePropertyName("supportPlanDisplayName"u8);
                writer.WriteStringValue(SupportPlanDisplayName);
            }
            writer.WritePropertyName("title"u8);
            writer.WriteStringValue(Title);
            if (Optional.IsDefined(ProblemStartOn))
            {
                writer.WritePropertyName("problemStartTime"u8);
                writer.WriteStringValue(ProblemStartOn.Value, "O");
            }
            writer.WritePropertyName("serviceId"u8);
            writer.WriteStringValue(ServiceId);
            if (options.Format != "W" && Optional.IsDefined(ServiceDisplayName))
            {
                writer.WritePropertyName("serviceDisplayName"u8);
                writer.WriteStringValue(ServiceDisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status);
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedOn))
            {
                writer.WritePropertyName("createdDate"u8);
                writer.WriteStringValue(CreatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ModifiedOn))
            {
                writer.WritePropertyName("modifiedDate"u8);
                writer.WriteStringValue(ModifiedOn.Value, "O");
            }
            if (Optional.IsDefined(FileWorkspaceName))
            {
                writer.WritePropertyName("fileWorkspaceName"u8);
                writer.WriteStringValue(FileWorkspaceName);
            }
            if (options.Format != "W" && Optional.IsDefined(IsTemporaryTicket))
            {
                writer.WritePropertyName("isTemporaryTicket"u8);
                writer.WriteStringValue(IsTemporaryTicket.Value.ToString());
            }
            if (Optional.IsDefined(TechnicalTicketDetails))
            {
                writer.WritePropertyName("technicalTicketDetails"u8);
                writer.WriteObjectValue(TechnicalTicketDetails, options);
            }
            if (Optional.IsDefined(QuotaTicketDetails))
            {
                writer.WritePropertyName("quotaTicketDetails"u8);
                writer.WriteObjectValue(QuotaTicketDetails, options);
            }
            if (Optional.IsCollectionDefined(SecondaryConsent))
            {
                writer.WritePropertyName("secondaryConsent"u8);
                writer.WriteStartArray();
                foreach (var item in SecondaryConsent)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        SupportTicketData IJsonModel<SupportTicketData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SupportTicketData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SupportTicketData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSupportTicketData(document.RootElement, options);
        }

        internal static SupportTicketData DeserializeSupportTicketData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string supportTicketId = default;
            string description = default;
            string problemClassificationId = default;
            string problemClassificationDisplayName = default;
            SupportSeverityLevel severity = default;
            string enrollmentId = default;
            bool? require24X7Response = default;
            AdvancedDiagnosticConsent advancedDiagnosticConsent = default;
            string problemScopingQuestions = default;
            string supportPlanId = default;
            SupportContactProfile contactDetails = default;
            SupportServiceLevelAgreement serviceLevelAgreement = default;
            SupportEngineer supportEngineer = default;
            string supportPlanType = default;
            string supportPlanDisplayName = default;
            string title = default;
            DateTimeOffset? problemStartTime = default;
            string serviceId = default;
            string serviceDisplayName = default;
            string status = default;
            DateTimeOffset? createdDate = default;
            DateTimeOffset? modifiedDate = default;
            string fileWorkspaceName = default;
            IsTemporaryTicket? isTemporaryTicket = default;
            TechnicalTicketDetails technicalTicketDetails = default;
            QuotaTicketDetails quotaTicketDetails = default;
            IList<SecondaryConsent> secondaryConsent = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("supportTicketId"u8))
                        {
                            supportTicketId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("problemClassificationId"u8))
                        {
                            problemClassificationId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("problemClassificationDisplayName"u8))
                        {
                            problemClassificationDisplayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("severity"u8))
                        {
                            severity = new SupportSeverityLevel(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("enrollmentId"u8))
                        {
                            enrollmentId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("require24X7Response"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            require24X7Response = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("advancedDiagnosticConsent"u8))
                        {
                            advancedDiagnosticConsent = new AdvancedDiagnosticConsent(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("problemScopingQuestions"u8))
                        {
                            problemScopingQuestions = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("supportPlanId"u8))
                        {
                            supportPlanId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("contactDetails"u8))
                        {
                            contactDetails = SupportContactProfile.DeserializeSupportContactProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("serviceLevelAgreement"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            serviceLevelAgreement = SupportServiceLevelAgreement.DeserializeSupportServiceLevelAgreement(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("supportEngineer"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            supportEngineer = SupportEngineer.DeserializeSupportEngineer(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("supportPlanType"u8))
                        {
                            supportPlanType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("supportPlanDisplayName"u8))
                        {
                            supportPlanDisplayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("title"u8))
                        {
                            title = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("problemStartTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            problemStartTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("serviceId"u8))
                        {
                            serviceId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("serviceDisplayName"u8))
                        {
                            serviceDisplayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("status"u8))
                        {
                            status = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("createdDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            createdDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("modifiedDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            modifiedDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("fileWorkspaceName"u8))
                        {
                            fileWorkspaceName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("isTemporaryTicket"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isTemporaryTicket = new IsTemporaryTicket(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("technicalTicketDetails"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            technicalTicketDetails = TechnicalTicketDetails.DeserializeTechnicalTicketDetails(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("quotaTicketDetails"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            quotaTicketDetails = QuotaTicketDetails.DeserializeQuotaTicketDetails(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("secondaryConsent"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SecondaryConsent> array = new List<SecondaryConsent>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(Models.SecondaryConsent.DeserializeSecondaryConsent(item, options));
                            }
                            secondaryConsent = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SupportTicketData(
                id,
                name,
                type,
                systemData,
                supportTicketId,
                description,
                problemClassificationId,
                problemClassificationDisplayName,
                severity,
                enrollmentId,
                require24X7Response,
                advancedDiagnosticConsent,
                problemScopingQuestions,
                supportPlanId,
                contactDetails,
                serviceLevelAgreement,
                supportEngineer,
                supportPlanType,
                supportPlanDisplayName,
                title,
                problemStartTime,
                serviceId,
                serviceDisplayName,
                status,
                createdDate,
                modifiedDate,
                fileWorkspaceName,
                isTemporaryTicket,
                technicalTicketDetails,
                quotaTicketDetails,
                secondaryConsent ?? new ChangeTrackingList<SecondaryConsent>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SupportTicketData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SupportTicketData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SupportTicketData)} does not support writing '{options.Format}' format.");
            }
        }

        SupportTicketData IPersistableModel<SupportTicketData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SupportTicketData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSupportTicketData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SupportTicketData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SupportTicketData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
