// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Support
{
    /// <summary>
    /// A class representing the SupportFileDetail data model.
    /// Object that represents File Details resource
    /// </summary>
    public partial class SupportFileDetailData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SupportFileDetailData"/>. </summary>
        public SupportFileDetailData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SupportFileDetailData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="createdOn"> Time in UTC (ISO 8601 format) when file workspace was created. </param>
        /// <param name="chunkSize"> Size of each chunk. The size of each chunk should be provided in bytes and must not exceed 2.5 megabytes (MB). </param>
        /// <param name="fileSize"> Size of the file to be uploaded. The file size must not exceed 5 MB and should be provided in bytes. </param>
        /// <param name="numberOfChunks"> Number of chunks to be uploaded. The maximum number of allowed chunks is 2. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SupportFileDetailData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? createdOn, int? chunkSize, int? fileSize, int? numberOfChunks, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            CreatedOn = createdOn;
            ChunkSize = chunkSize;
            FileSize = fileSize;
            NumberOfChunks = numberOfChunks;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Time in UTC (ISO 8601 format) when file workspace was created. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Size of each chunk. The size of each chunk should be provided in bytes and must not exceed 2.5 megabytes (MB). </summary>
        public int? ChunkSize { get; set; }
        /// <summary> Size of the file to be uploaded. The file size must not exceed 5 MB and should be provided in bytes. </summary>
        public int? FileSize { get; set; }
        /// <summary> Number of chunks to be uploaded. The maximum number of allowed chunks is 2. </summary>
        public int? NumberOfChunks { get; set; }
    }
}
