// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Support.Models
{
    /// <summary> User consent value provided. </summary>
    public readonly partial struct UserConsent : IEquatable<UserConsent>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UserConsent"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UserConsent(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string YesValue = "Yes";
        private const string NoValue = "No";

        /// <summary> Yes. </summary>
        public static UserConsent Yes { get; } = new UserConsent(YesValue);
        /// <summary> No. </summary>
        public static UserConsent No { get; } = new UserConsent(NoValue);
        /// <summary> Determines if two <see cref="UserConsent"/> values are the same. </summary>
        public static bool operator ==(UserConsent left, UserConsent right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UserConsent"/> values are not the same. </summary>
        public static bool operator !=(UserConsent left, UserConsent right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UserConsent"/>. </summary>
        public static implicit operator UserConsent(string value) => new UserConsent(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UserConsent other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UserConsent other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
