// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Support.Models
{
    /// <summary> Updates severity, ticket status, contact details, advanced diagnostic consent and secondary consent in the support ticket. </summary>
    public partial class UpdateSupportTicket
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UpdateSupportTicket"/>. </summary>
        public UpdateSupportTicket()
        {
            SecondaryConsent = new ChangeTrackingList<SecondaryConsent>();
        }

        /// <summary> Initializes a new instance of <see cref="UpdateSupportTicket"/>. </summary>
        /// <param name="severity"> Severity level. </param>
        /// <param name="status"> Status to be updated on the ticket. </param>
        /// <param name="contactDetails"> Contact details to be updated on the support ticket. </param>
        /// <param name="advancedDiagnosticConsent"> Advanced diagnostic consent to be updated on the support ticket. </param>
        /// <param name="secondaryConsent"> This property indicates secondary consents for the support ticket. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UpdateSupportTicket(SupportSeverityLevel? severity, SupportTicketStatus? status, SupportContactProfileContent contactDetails, AdvancedDiagnosticConsent? advancedDiagnosticConsent, IList<SecondaryConsent> secondaryConsent, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Severity = severity;
            Status = status;
            ContactDetails = contactDetails;
            AdvancedDiagnosticConsent = advancedDiagnosticConsent;
            SecondaryConsent = secondaryConsent;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Severity level. </summary>
        public SupportSeverityLevel? Severity { get; set; }
        /// <summary> Status to be updated on the ticket. </summary>
        public SupportTicketStatus? Status { get; set; }
        /// <summary> Contact details to be updated on the support ticket. </summary>
        public SupportContactProfileContent ContactDetails { get; set; }
        /// <summary> Advanced diagnostic consent to be updated on the support ticket. </summary>
        public AdvancedDiagnosticConsent? AdvancedDiagnosticConsent { get; set; }
        /// <summary> This property indicates secondary consents for the support ticket. </summary>
        public IList<SecondaryConsent> SecondaryConsent { get; }
    }
}
