// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Support.Models
{
    /// <summary> Status to be updated on the ticket. </summary>
    public readonly partial struct SupportTicketStatus : IEquatable<SupportTicketStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SupportTicketStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SupportTicketStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OpenValue = "open";
        private const string ClosedValue = "closed";

        /// <summary> open. </summary>
        public static SupportTicketStatus Open { get; } = new SupportTicketStatus(OpenValue);
        /// <summary> closed. </summary>
        public static SupportTicketStatus Closed { get; } = new SupportTicketStatus(ClosedValue);
        /// <summary> Determines if two <see cref="SupportTicketStatus"/> values are the same. </summary>
        public static bool operator ==(SupportTicketStatus left, SupportTicketStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SupportTicketStatus"/> values are not the same. </summary>
        public static bool operator !=(SupportTicketStatus left, SupportTicketStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SupportTicketStatus"/>. </summary>
        public static implicit operator SupportTicketStatus(string value) => new SupportTicketStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SupportTicketStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SupportTicketStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
