// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Support.Models
{
    /// <summary> Communication type. </summary>
    public readonly partial struct SupportTicketCommunicationType : IEquatable<SupportTicketCommunicationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SupportTicketCommunicationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SupportTicketCommunicationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WebValue = "web";
        private const string PhoneValue = "phone";

        /// <summary> web. </summary>
        public static SupportTicketCommunicationType Web { get; } = new SupportTicketCommunicationType(WebValue);
        /// <summary> phone. </summary>
        public static SupportTicketCommunicationType Phone { get; } = new SupportTicketCommunicationType(PhoneValue);
        /// <summary> Determines if two <see cref="SupportTicketCommunicationType"/> values are the same. </summary>
        public static bool operator ==(SupportTicketCommunicationType left, SupportTicketCommunicationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SupportTicketCommunicationType"/> values are not the same. </summary>
        public static bool operator !=(SupportTicketCommunicationType left, SupportTicketCommunicationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SupportTicketCommunicationType"/>. </summary>
        public static implicit operator SupportTicketCommunicationType(string value) => new SupportTicketCommunicationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SupportTicketCommunicationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SupportTicketCommunicationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
