// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Support.Models
{
    /// <summary> Direction of communication. </summary>
    public readonly partial struct SupportTicketCommunicationDirection : IEquatable<SupportTicketCommunicationDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SupportTicketCommunicationDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SupportTicketCommunicationDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InboundValue = "inbound";
        private const string OutboundValue = "outbound";

        /// <summary> inbound. </summary>
        public static SupportTicketCommunicationDirection Inbound { get; } = new SupportTicketCommunicationDirection(InboundValue);
        /// <summary> outbound. </summary>
        public static SupportTicketCommunicationDirection Outbound { get; } = new SupportTicketCommunicationDirection(OutboundValue);
        /// <summary> Determines if two <see cref="SupportTicketCommunicationDirection"/> values are the same. </summary>
        public static bool operator ==(SupportTicketCommunicationDirection left, SupportTicketCommunicationDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SupportTicketCommunicationDirection"/> values are not the same. </summary>
        public static bool operator !=(SupportTicketCommunicationDirection left, SupportTicketCommunicationDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SupportTicketCommunicationDirection"/>. </summary>
        public static implicit operator SupportTicketCommunicationDirection(string value) => new SupportTicketCommunicationDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SupportTicketCommunicationDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SupportTicketCommunicationDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
