// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Support.Models
{
    /// <summary> A value that indicates the urgency of the case, which in turn determines the response time according to the service level agreement of the technical support plan you have with Azure. Note: 'Highest critical impact', also known as the 'Emergency - Severe impact' level in the Azure portal is reserved only for our Premium customers. </summary>
    public readonly partial struct SupportSeverityLevel : IEquatable<SupportSeverityLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SupportSeverityLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SupportSeverityLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MinimalValue = "minimal";
        private const string ModerateValue = "moderate";
        private const string CriticalValue = "critical";
        private const string HighestcriticalimpactValue = "highestcriticalimpact";

        /// <summary> minimal. </summary>
        public static SupportSeverityLevel Minimal { get; } = new SupportSeverityLevel(MinimalValue);
        /// <summary> moderate. </summary>
        public static SupportSeverityLevel Moderate { get; } = new SupportSeverityLevel(ModerateValue);
        /// <summary> critical. </summary>
        public static SupportSeverityLevel Critical { get; } = new SupportSeverityLevel(CriticalValue);
        /// <summary> highestcriticalimpact. </summary>
        public static SupportSeverityLevel Highestcriticalimpact { get; } = new SupportSeverityLevel(HighestcriticalimpactValue);
        /// <summary> Determines if two <see cref="SupportSeverityLevel"/> values are the same. </summary>
        public static bool operator ==(SupportSeverityLevel left, SupportSeverityLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SupportSeverityLevel"/> values are not the same. </summary>
        public static bool operator !=(SupportSeverityLevel left, SupportSeverityLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SupportSeverityLevel"/>. </summary>
        public static implicit operator SupportSeverityLevel(string value) => new SupportSeverityLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SupportSeverityLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SupportSeverityLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
