// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Support.Models
{
    /// <summary> Service Level Agreement details for a support ticket. </summary>
    public partial class SupportServiceLevelAgreement
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SupportServiceLevelAgreement"/>. </summary>
        public SupportServiceLevelAgreement()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SupportServiceLevelAgreement"/>. </summary>
        /// <param name="startOn"> Time in UTC (ISO 8601 format) when the service level agreement starts. </param>
        /// <param name="expireOn"> Time in UTC (ISO 8601 format) when the service level agreement expires. </param>
        /// <param name="slaInMinutes"> Service Level Agreement in minutes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SupportServiceLevelAgreement(DateTimeOffset? startOn, DateTimeOffset? expireOn, int? slaInMinutes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StartOn = startOn;
            ExpireOn = expireOn;
            SlaInMinutes = slaInMinutes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Time in UTC (ISO 8601 format) when the service level agreement starts. </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> Time in UTC (ISO 8601 format) when the service level agreement expires. </summary>
        public DateTimeOffset? ExpireOn { get; }
        /// <summary> Service Level Agreement in minutes. </summary>
        public int? SlaInMinutes { get; }
    }
}
