// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Support.Models
{
    /// <summary> This property indicates whether secondary consent is present for problem classification. </summary>
    public partial class SecondaryConsentEnabled
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecondaryConsentEnabled"/>. </summary>
        internal SecondaryConsentEnabled()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecondaryConsentEnabled"/>. </summary>
        /// <param name="description"> User consent description. </param>
        /// <param name="secondaryConsentEnabledType"> The Azure service for which secondary consent is needed for case creation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecondaryConsentEnabled(string description, string secondaryConsentEnabledType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Description = description;
            SecondaryConsentEnabledType = secondaryConsentEnabledType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> User consent description. </summary>
        public string Description { get; }
        /// <summary> The Azure service for which secondary consent is needed for case creation. </summary>
        public string SecondaryConsentEnabledType { get; }
    }
}
