// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Support.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableSupportArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableSupportArmClient"/> class for mocking. </summary>
        protected MockableSupportArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableSupportArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableSupportArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableSupportArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="SupportAzureServiceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SupportAzureServiceResource.CreateResourceIdentifier" /> to create a <see cref="SupportAzureServiceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SupportAzureServiceResource"/> object. </returns>
        public virtual SupportAzureServiceResource GetSupportAzureServiceResource(ResourceIdentifier id)
        {
            SupportAzureServiceResource.ValidateResourceId(id);
            return new SupportAzureServiceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ProblemClassificationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ProblemClassificationResource.CreateResourceIdentifier" /> to create a <see cref="ProblemClassificationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ProblemClassificationResource"/> object. </returns>
        public virtual ProblemClassificationResource GetProblemClassificationResource(ResourceIdentifier id)
        {
            ProblemClassificationResource.ValidateResourceId(id);
            return new ProblemClassificationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SubscriptionSupportTicketResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SubscriptionSupportTicketResource.CreateResourceIdentifier" /> to create a <see cref="SubscriptionSupportTicketResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SubscriptionSupportTicketResource"/> object. </returns>
        public virtual SubscriptionSupportTicketResource GetSubscriptionSupportTicketResource(ResourceIdentifier id)
        {
            SubscriptionSupportTicketResource.ValidateResourceId(id);
            return new SubscriptionSupportTicketResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="TenantSupportTicketResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="TenantSupportTicketResource.CreateResourceIdentifier" /> to create a <see cref="TenantSupportTicketResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="TenantSupportTicketResource"/> object. </returns>
        public virtual TenantSupportTicketResource GetTenantSupportTicketResource(ResourceIdentifier id)
        {
            TenantSupportTicketResource.ValidateResourceId(id);
            return new TenantSupportTicketResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SupportTicketCommunicationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SupportTicketCommunicationResource.CreateResourceIdentifier" /> to create a <see cref="SupportTicketCommunicationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SupportTicketCommunicationResource"/> object. </returns>
        public virtual SupportTicketCommunicationResource GetSupportTicketCommunicationResource(ResourceIdentifier id)
        {
            SupportTicketCommunicationResource.ValidateResourceId(id);
            return new SupportTicketCommunicationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SupportTicketNoSubCommunicationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SupportTicketNoSubCommunicationResource.CreateResourceIdentifier" /> to create a <see cref="SupportTicketNoSubCommunicationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SupportTicketNoSubCommunicationResource"/> object. </returns>
        public virtual SupportTicketNoSubCommunicationResource GetSupportTicketNoSubCommunicationResource(ResourceIdentifier id)
        {
            SupportTicketNoSubCommunicationResource.ValidateResourceId(id);
            return new SupportTicketNoSubCommunicationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SupportTicketChatTranscriptResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SupportTicketChatTranscriptResource.CreateResourceIdentifier" /> to create a <see cref="SupportTicketChatTranscriptResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SupportTicketChatTranscriptResource"/> object. </returns>
        public virtual SupportTicketChatTranscriptResource GetSupportTicketChatTranscriptResource(ResourceIdentifier id)
        {
            SupportTicketChatTranscriptResource.ValidateResourceId(id);
            return new SupportTicketChatTranscriptResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SupportTicketNoSubChatTranscriptResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SupportTicketNoSubChatTranscriptResource.CreateResourceIdentifier" /> to create a <see cref="SupportTicketNoSubChatTranscriptResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SupportTicketNoSubChatTranscriptResource"/> object. </returns>
        public virtual SupportTicketNoSubChatTranscriptResource GetSupportTicketNoSubChatTranscriptResource(ResourceIdentifier id)
        {
            SupportTicketNoSubChatTranscriptResource.ValidateResourceId(id);
            return new SupportTicketNoSubChatTranscriptResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SubscriptionFileWorkspaceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SubscriptionFileWorkspaceResource.CreateResourceIdentifier" /> to create a <see cref="SubscriptionFileWorkspaceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SubscriptionFileWorkspaceResource"/> object. </returns>
        public virtual SubscriptionFileWorkspaceResource GetSubscriptionFileWorkspaceResource(ResourceIdentifier id)
        {
            SubscriptionFileWorkspaceResource.ValidateResourceId(id);
            return new SubscriptionFileWorkspaceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="TenantFileWorkspaceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="TenantFileWorkspaceResource.CreateResourceIdentifier" /> to create a <see cref="TenantFileWorkspaceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="TenantFileWorkspaceResource"/> object. </returns>
        public virtual TenantFileWorkspaceResource GetTenantFileWorkspaceResource(ResourceIdentifier id)
        {
            TenantFileWorkspaceResource.ValidateResourceId(id);
            return new TenantFileWorkspaceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SupportTicketFileResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SupportTicketFileResource.CreateResourceIdentifier" /> to create a <see cref="SupportTicketFileResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SupportTicketFileResource"/> object. </returns>
        public virtual SupportTicketFileResource GetSupportTicketFileResource(ResourceIdentifier id)
        {
            SupportTicketFileResource.ValidateResourceId(id);
            return new SupportTicketFileResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SupportTicketNoSubFileResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SupportTicketNoSubFileResource.CreateResourceIdentifier" /> to create a <see cref="SupportTicketNoSubFileResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SupportTicketNoSubFileResource"/> object. </returns>
        public virtual SupportTicketNoSubFileResource GetSupportTicketNoSubFileResource(ResourceIdentifier id)
        {
            SupportTicketNoSubFileResource.ValidateResourceId(id);
            return new SupportTicketNoSubFileResource(Client, id);
        }
    }
}
