// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Support.Models;

namespace Azure.ResourceManager.Support.Samples
{
    public partial class Sample_TenantSupportTicketResource
    {
        // Checks whether name is available for SupportTicket resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckNameAvailabilitySupportTicketsNoSubscription_ChecksWhetherNameIsAvailableForSupportTicketResource()
        {
            // Generated from example definition: specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/CheckNameAvailability.json
            // this example is just showing the usage of "SupportTicketsNoSubscription_CheckNameAvailability" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            SupportNameAvailabilityContent content = new SupportNameAvailabilityContent("sampleName", SupportResourceType.MicrosoftSupportSupportTickets);
            SupportNameAvailabilityResult result = await tenantResource.CheckNameAvailabilitySupportTicketsNoSubscriptionAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get details of a ticket
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDetailsOfATicket()
        {
            // Generated from example definition: specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/GetSupportTicketDetails.json
            // this example is just showing the usage of "SupportTicketsNoSubscription_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantSupportTicketResource created on azure
            // for more information of creating TenantSupportTicketResource, please refer to the document of TenantSupportTicketResource
            string supportTicketName = "testticket";
            ResourceIdentifier tenantSupportTicketResourceId = TenantSupportTicketResource.CreateResourceIdentifier(supportTicketName);
            TenantSupportTicketResource tenantSupportTicket = client.GetTenantSupportTicketResource(tenantSupportTicketResourceId);

            // invoke the operation
            TenantSupportTicketResource result = await tenantSupportTicket.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SupportTicketData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update advanced diagnostic consent of a support ticket
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAdvancedDiagnosticConsentOfASupportTicket()
        {
            // Generated from example definition: specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/UpdateAdvancedDiagnosticConsentOfSupportTicket.json
            // this example is just showing the usage of "SupportTicketsNoSubscription_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantSupportTicketResource created on azure
            // for more information of creating TenantSupportTicketResource, please refer to the document of TenantSupportTicketResource
            string supportTicketName = "testticket";
            ResourceIdentifier tenantSupportTicketResourceId = TenantSupportTicketResource.CreateResourceIdentifier(supportTicketName);
            TenantSupportTicketResource tenantSupportTicket = client.GetTenantSupportTicketResource(tenantSupportTicketResourceId);

            // invoke the operation
            UpdateSupportTicket updateSupportTicket = new UpdateSupportTicket()
            {
                AdvancedDiagnosticConsent = AdvancedDiagnosticConsent.Yes,
            };
            TenantSupportTicketResource result = await tenantSupportTicket.UpdateAsync(updateSupportTicket);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SupportTicketData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update contact details of a support ticket
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateContactDetailsOfASupportTicket()
        {
            // Generated from example definition: specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/UpdateContactDetailsOfSupportTicket.json
            // this example is just showing the usage of "SupportTicketsNoSubscription_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantSupportTicketResource created on azure
            // for more information of creating TenantSupportTicketResource, please refer to the document of TenantSupportTicketResource
            string supportTicketName = "testticket";
            ResourceIdentifier tenantSupportTicketResourceId = TenantSupportTicketResource.CreateResourceIdentifier(supportTicketName);
            TenantSupportTicketResource tenantSupportTicket = client.GetTenantSupportTicketResource(tenantSupportTicketResourceId);

            // invoke the operation
            UpdateSupportTicket updateSupportTicket = new UpdateSupportTicket()
            {
                ContactDetails = new SupportContactProfileContent()
                {
                    FirstName = "first name",
                    LastName = "last name",
                    PreferredContactMethod = PreferredContactMethod.Email,
                    PrimaryEmailAddress = "test.name@contoso.com",
                    AdditionalEmailAddresses =
{
"tname@contoso.com","teamtest@contoso.com"
},
                    PhoneNumber = "123-456-7890",
                    PreferredTimeZone = "Pacific Standard Time",
                    Country = "USA",
                    PreferredSupportLanguage = "en-US",
                },
            };
            TenantSupportTicketResource result = await tenantSupportTicket.UpdateAsync(updateSupportTicket);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SupportTicketData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update severity of a support ticket
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateSeverityOfASupportTicket()
        {
            // Generated from example definition: specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/UpdateSeverityOfSupportTicket.json
            // this example is just showing the usage of "SupportTicketsNoSubscription_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantSupportTicketResource created on azure
            // for more information of creating TenantSupportTicketResource, please refer to the document of TenantSupportTicketResource
            string supportTicketName = "testticket";
            ResourceIdentifier tenantSupportTicketResourceId = TenantSupportTicketResource.CreateResourceIdentifier(supportTicketName);
            TenantSupportTicketResource tenantSupportTicket = client.GetTenantSupportTicketResource(tenantSupportTicketResourceId);

            // invoke the operation
            UpdateSupportTicket updateSupportTicket = new UpdateSupportTicket()
            {
                Severity = SupportSeverityLevel.Critical,
            };
            TenantSupportTicketResource result = await tenantSupportTicket.UpdateAsync(updateSupportTicket);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SupportTicketData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update status of a support ticket
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateStatusOfASupportTicket()
        {
            // Generated from example definition: specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/UpdateStatusOfSupportTicket.json
            // this example is just showing the usage of "SupportTicketsNoSubscription_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantSupportTicketResource created on azure
            // for more information of creating TenantSupportTicketResource, please refer to the document of TenantSupportTicketResource
            string supportTicketName = "testticket";
            ResourceIdentifier tenantSupportTicketResourceId = TenantSupportTicketResource.CreateResourceIdentifier(supportTicketName);
            TenantSupportTicketResource tenantSupportTicket = client.GetTenantSupportTicketResource(tenantSupportTicketResourceId);

            // invoke the operation
            UpdateSupportTicket updateSupportTicket = new UpdateSupportTicket()
            {
                Status = SupportTicketStatus.Closed,
            };
            TenantSupportTicketResource result = await tenantSupportTicket.UpdateAsync(updateSupportTicket);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SupportTicketData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Checks whether name is available for Communication resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckNameAvailabilityCommunicationsNoSubscription_ChecksWhetherNameIsAvailableForCommunicationResource()
        {
            // Generated from example definition: specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/CheckNameAvailabilityForNoSubscriptionSupportTicketCommunication.json
            // this example is just showing the usage of "CommunicationsNoSubscription_CheckNameAvailability" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantSupportTicketResource created on azure
            // for more information of creating TenantSupportTicketResource, please refer to the document of TenantSupportTicketResource
            string supportTicketName = "testticket";
            ResourceIdentifier tenantSupportTicketResourceId = TenantSupportTicketResource.CreateResourceIdentifier(supportTicketName);
            TenantSupportTicketResource tenantSupportTicket = client.GetTenantSupportTicketResource(tenantSupportTicketResourceId);

            // invoke the operation
            SupportNameAvailabilityContent content = new SupportNameAvailabilityContent("sampleName", SupportResourceType.MicrosoftSupportCommunications);
            SupportNameAvailabilityResult result = await tenantSupportTicket.CheckNameAvailabilityCommunicationsNoSubscriptionAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
