// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Support.Samples
{
    public partial class Sample_SupportTicketFileCollection
    {
        // List files under a workspace for a subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListFilesUnderAWorkspaceForASubscription()
        {
            // Generated from example definition: specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/ListFilesForSubscriptionUnderFileWorkspace.json
            // this example is just showing the usage of "Files_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionFileWorkspaceResource created on azure
            // for more information of creating SubscriptionFileWorkspaceResource, please refer to the document of SubscriptionFileWorkspaceResource
            string subscriptionId = "132d901f-189d-4381-9214-fe68e27e05a1";
            string fileWorkspaceName = "testworkspace";
            ResourceIdentifier subscriptionFileWorkspaceResourceId = SubscriptionFileWorkspaceResource.CreateResourceIdentifier(subscriptionId, fileWorkspaceName);
            SubscriptionFileWorkspaceResource subscriptionFileWorkspace = client.GetSubscriptionFileWorkspaceResource(subscriptionFileWorkspaceResourceId);

            // get the collection of this SupportTicketFileResource
            SupportTicketFileCollection collection = subscriptionFileWorkspace.GetSupportTicketFiles();

            // invoke the operation and iterate over the result
            await foreach (SupportTicketFileResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SupportFileDetailData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get details of a subscription file
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDetailsOfASubscriptionFile()
        {
            // Generated from example definition: specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/GetFileDetailsForSubscription.json
            // this example is just showing the usage of "Files_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionFileWorkspaceResource created on azure
            // for more information of creating SubscriptionFileWorkspaceResource, please refer to the document of SubscriptionFileWorkspaceResource
            string subscriptionId = "132d901f-189d-4381-9214-fe68e27e05a1";
            string fileWorkspaceName = "testworkspace";
            ResourceIdentifier subscriptionFileWorkspaceResourceId = SubscriptionFileWorkspaceResource.CreateResourceIdentifier(subscriptionId, fileWorkspaceName);
            SubscriptionFileWorkspaceResource subscriptionFileWorkspace = client.GetSubscriptionFileWorkspaceResource(subscriptionFileWorkspaceResourceId);

            // get the collection of this SupportTicketFileResource
            SupportTicketFileCollection collection = subscriptionFileWorkspace.GetSupportTicketFiles();

            // invoke the operation
            string fileName = "test.txt";
            SupportTicketFileResource result = await collection.GetAsync(fileName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SupportFileDetailData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get details of a subscription file
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetDetailsOfASubscriptionFile()
        {
            // Generated from example definition: specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/GetFileDetailsForSubscription.json
            // this example is just showing the usage of "Files_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionFileWorkspaceResource created on azure
            // for more information of creating SubscriptionFileWorkspaceResource, please refer to the document of SubscriptionFileWorkspaceResource
            string subscriptionId = "132d901f-189d-4381-9214-fe68e27e05a1";
            string fileWorkspaceName = "testworkspace";
            ResourceIdentifier subscriptionFileWorkspaceResourceId = SubscriptionFileWorkspaceResource.CreateResourceIdentifier(subscriptionId, fileWorkspaceName);
            SubscriptionFileWorkspaceResource subscriptionFileWorkspace = client.GetSubscriptionFileWorkspaceResource(subscriptionFileWorkspaceResourceId);

            // get the collection of this SupportTicketFileResource
            SupportTicketFileCollection collection = subscriptionFileWorkspace.GetSupportTicketFiles();

            // invoke the operation
            string fileName = "test.txt";
            bool result = await collection.ExistsAsync(fileName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get details of a subscription file
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetDetailsOfASubscriptionFile()
        {
            // Generated from example definition: specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/GetFileDetailsForSubscription.json
            // this example is just showing the usage of "Files_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionFileWorkspaceResource created on azure
            // for more information of creating SubscriptionFileWorkspaceResource, please refer to the document of SubscriptionFileWorkspaceResource
            string subscriptionId = "132d901f-189d-4381-9214-fe68e27e05a1";
            string fileWorkspaceName = "testworkspace";
            ResourceIdentifier subscriptionFileWorkspaceResourceId = SubscriptionFileWorkspaceResource.CreateResourceIdentifier(subscriptionId, fileWorkspaceName);
            SubscriptionFileWorkspaceResource subscriptionFileWorkspace = client.GetSubscriptionFileWorkspaceResource(subscriptionFileWorkspaceResourceId);

            // get the collection of this SupportTicketFileResource
            SupportTicketFileCollection collection = subscriptionFileWorkspace.GetSupportTicketFiles();

            // invoke the operation
            string fileName = "test.txt";
            NullableResponse<SupportTicketFileResource> response = await collection.GetIfExistsAsync(fileName);
            SupportTicketFileResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SupportFileDetailData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create a file under a subscription workspace
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAFileUnderASubscriptionWorkspace()
        {
            // Generated from example definition: specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/CreateFileForSubscription.json
            // this example is just showing the usage of "Files_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionFileWorkspaceResource created on azure
            // for more information of creating SubscriptionFileWorkspaceResource, please refer to the document of SubscriptionFileWorkspaceResource
            string subscriptionId = "132d901f-189d-4381-9214-fe68e27e05a1";
            string fileWorkspaceName = "testworkspace";
            ResourceIdentifier subscriptionFileWorkspaceResourceId = SubscriptionFileWorkspaceResource.CreateResourceIdentifier(subscriptionId, fileWorkspaceName);
            SubscriptionFileWorkspaceResource subscriptionFileWorkspace = client.GetSubscriptionFileWorkspaceResource(subscriptionFileWorkspaceResourceId);

            // get the collection of this SupportTicketFileResource
            SupportTicketFileCollection collection = subscriptionFileWorkspace.GetSupportTicketFiles();

            // invoke the operation
            string fileName = "test.txt";
            SupportFileDetailData data = new SupportFileDetailData()
            {
                ChunkSize = 41423,
                FileSize = 41423,
                NumberOfChunks = 1,
            };
            ArmOperation<SupportTicketFileResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, fileName, data);
            SupportTicketFileResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SupportFileDetailData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
