// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Subscription.Models
{
    /// <summary> Tenant policy. </summary>
    public partial class TenantPolicyProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TenantPolicyProperties"/>. </summary>
        internal TenantPolicyProperties()
        {
            ExemptedPrincipals = new ChangeTrackingList<Guid>();
        }

        /// <summary> Initializes a new instance of <see cref="TenantPolicyProperties"/>. </summary>
        /// <param name="policyId"> Policy Id. </param>
        /// <param name="blockSubscriptionsLeavingTenant"> Blocks the leaving of subscriptions from user's tenant. </param>
        /// <param name="blockSubscriptionsIntoTenant"> Blocks the entering of subscriptions into user's tenant. </param>
        /// <param name="exemptedPrincipals"> List of user objectIds that are exempted from the set subscription tenant policies for the user's tenant. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TenantPolicyProperties(string policyId, bool? blockSubscriptionsLeavingTenant, bool? blockSubscriptionsIntoTenant, IReadOnlyList<Guid> exemptedPrincipals, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PolicyId = policyId;
            BlockSubscriptionsLeavingTenant = blockSubscriptionsLeavingTenant;
            BlockSubscriptionsIntoTenant = blockSubscriptionsIntoTenant;
            ExemptedPrincipals = exemptedPrincipals;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Policy Id. </summary>
        public string PolicyId { get; }
        /// <summary> Blocks the leaving of subscriptions from user's tenant. </summary>
        public bool? BlockSubscriptionsLeavingTenant { get; }
        /// <summary> Blocks the entering of subscriptions into user's tenant. </summary>
        public bool? BlockSubscriptionsIntoTenant { get; }
        /// <summary> List of user objectIds that are exempted from the set subscription tenant policies for the user's tenant. </summary>
        public IReadOnlyList<Guid> ExemptedPrincipals { get; }
    }
}
