// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Subscription.Models
{
    /// <summary> Put tenant policy request properties. </summary>
    public partial class TenantPolicyCreateOrUpdateContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TenantPolicyCreateOrUpdateContent"/>. </summary>
        public TenantPolicyCreateOrUpdateContent()
        {
            ExemptedPrincipals = new ChangeTrackingList<Guid>();
        }

        /// <summary> Initializes a new instance of <see cref="TenantPolicyCreateOrUpdateContent"/>. </summary>
        /// <param name="blockSubscriptionsLeavingTenant"> Blocks the leaving of subscriptions from user's tenant. </param>
        /// <param name="blockSubscriptionsIntoTenant"> Blocks the entering of subscriptions into user's tenant. </param>
        /// <param name="exemptedPrincipals"> List of user objectIds that are exempted from the set subscription tenant policies for the user's tenant. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TenantPolicyCreateOrUpdateContent(bool? blockSubscriptionsLeavingTenant, bool? blockSubscriptionsIntoTenant, IList<Guid> exemptedPrincipals, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BlockSubscriptionsLeavingTenant = blockSubscriptionsLeavingTenant;
            BlockSubscriptionsIntoTenant = blockSubscriptionsIntoTenant;
            ExemptedPrincipals = exemptedPrincipals;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Blocks the leaving of subscriptions from user's tenant. </summary>
        public bool? BlockSubscriptionsLeavingTenant { get; set; }
        /// <summary> Blocks the entering of subscriptions into user's tenant. </summary>
        public bool? BlockSubscriptionsIntoTenant { get; set; }
        /// <summary> List of user objectIds that are exempted from the set subscription tenant policies for the user's tenant. </summary>
        public IList<Guid> ExemptedPrincipals { get; }
    }
}
