// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Subscription.Models
{
    /// <summary> The workload type of the subscription. It can be either Production or DevTest. </summary>
    public readonly partial struct SubscriptionWorkload : IEquatable<SubscriptionWorkload>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SubscriptionWorkload"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SubscriptionWorkload(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProductionValue = "Production";
        private const string DevTestValue = "DevTest";

        /// <summary> Production. </summary>
        public static SubscriptionWorkload Production { get; } = new SubscriptionWorkload(ProductionValue);
        /// <summary> DevTest. </summary>
        public static SubscriptionWorkload DevTest { get; } = new SubscriptionWorkload(DevTestValue);
        /// <summary> Determines if two <see cref="SubscriptionWorkload"/> values are the same. </summary>
        public static bool operator ==(SubscriptionWorkload left, SubscriptionWorkload right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SubscriptionWorkload"/> values are not the same. </summary>
        public static bool operator !=(SubscriptionWorkload left, SubscriptionWorkload right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SubscriptionWorkload"/>. </summary>
        public static implicit operator SubscriptionWorkload(string value) => new SubscriptionWorkload(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SubscriptionWorkload other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SubscriptionWorkload other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
