// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Subscription.Models
{
    /// <summary> Put billing account policies response properties. </summary>
    public partial class BillingAccountPolicyProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingAccountPolicyProperties"/>. </summary>
        internal BillingAccountPolicyProperties()
        {
            ServiceTenants = new ChangeTrackingList<ServiceTenant>();
        }

        /// <summary> Initializes a new instance of <see cref="BillingAccountPolicyProperties"/>. </summary>
        /// <param name="serviceTenants"> Service tenant for the billing account. </param>
        /// <param name="allowTransfers"> Determine if the transfers are allowed for the billing account. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingAccountPolicyProperties(IReadOnlyList<ServiceTenant> serviceTenants, bool? allowTransfers, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ServiceTenants = serviceTenants;
            AllowTransfers = allowTransfers;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Service tenant for the billing account. </summary>
        public IReadOnlyList<ServiceTenant> ServiceTenants { get; }
        /// <summary> Determine if the transfers are allowed for the billing account. </summary>
        public bool? AllowTransfers { get; }
    }
}
