// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Subscription.Models
{
    /// <summary> The provisioning state of the resource. </summary>
    public readonly partial struct AcceptOwnershipProvisioningState : IEquatable<AcceptOwnershipProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AcceptOwnershipProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AcceptOwnershipProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string AcceptedValue = "Accepted";
        private const string SucceededValue = "Succeeded";

        /// <summary> Pending. </summary>
        public static AcceptOwnershipProvisioningState Pending { get; } = new AcceptOwnershipProvisioningState(PendingValue);
        /// <summary> Accepted. </summary>
        public static AcceptOwnershipProvisioningState Accepted { get; } = new AcceptOwnershipProvisioningState(AcceptedValue);
        /// <summary> Succeeded. </summary>
        public static AcceptOwnershipProvisioningState Succeeded { get; } = new AcceptOwnershipProvisioningState(SucceededValue);
        /// <summary> Determines if two <see cref="AcceptOwnershipProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AcceptOwnershipProvisioningState left, AcceptOwnershipProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AcceptOwnershipProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AcceptOwnershipProvisioningState left, AcceptOwnershipProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AcceptOwnershipProvisioningState"/>. </summary>
        public static implicit operator AcceptOwnershipProvisioningState(string value) => new AcceptOwnershipProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AcceptOwnershipProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AcceptOwnershipProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
