// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Subscription
{
    internal class SubscriptionAliasOperationSource : IOperationSource<SubscriptionAliasResource>
    {
        private readonly ArmClient _client;

        internal SubscriptionAliasOperationSource(ArmClient client)
        {
            _client = client;
        }

        SubscriptionAliasResource IOperationSource<SubscriptionAliasResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SubscriptionAliasData.DeserializeSubscriptionAliasData(document.RootElement);
            return new SubscriptionAliasResource(_client, data);
        }

        async ValueTask<SubscriptionAliasResource> IOperationSource<SubscriptionAliasResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SubscriptionAliasData.DeserializeSubscriptionAliasData(document.RootElement);
            return new SubscriptionAliasResource(_client, data);
        }
    }
}
