// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Subscription.Models;

namespace Azure.ResourceManager.Subscription.Mocking
{
    /// <summary> A class to add extension methods to SubscriptionResource. </summary>
    public partial class MockableSubscriptionSubscriptionResource : ArmResource
    {
        private ClientDiagnostics _subscriptionClientDiagnostics;
        private SubscriptionRestOperations _subscriptionRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableSubscriptionSubscriptionResource"/> class for mocking. </summary>
        protected MockableSubscriptionSubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableSubscriptionSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableSubscriptionSubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics SubscriptionClientDiagnostics => _subscriptionClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.Subscription", ProviderConstants.DefaultProviderNamespace, Diagnostics);
        private SubscriptionRestOperations SubscriptionRestClient => _subscriptionRestClient ??= new SubscriptionRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// The operation to cancel a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Subscription/cancel</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Subscription_Cancel</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<CanceledSubscriptionId>> CancelSubscriptionAsync(CancellationToken cancellationToken = default)
        {
            using var scope = SubscriptionClientDiagnostics.CreateScope("MockableSubscriptionSubscriptionResource.CancelSubscription");
            scope.Start();
            try
            {
                var response = await SubscriptionRestClient.CancelAsync(Id.SubscriptionId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to cancel a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Subscription/cancel</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Subscription_Cancel</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<CanceledSubscriptionId> CancelSubscription(CancellationToken cancellationToken = default)
        {
            using var scope = SubscriptionClientDiagnostics.CreateScope("MockableSubscriptionSubscriptionResource.CancelSubscription");
            scope.Start();
            try
            {
                var response = SubscriptionRestClient.Cancel(Id.SubscriptionId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to rename a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Subscription/rename</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Subscription_Rename</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="body"> Subscription Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public virtual async Task<Response<RenamedSubscriptionId>> RenameSubscriptionAsync(SubscriptionName body, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(body, nameof(body));

            using var scope = SubscriptionClientDiagnostics.CreateScope("MockableSubscriptionSubscriptionResource.RenameSubscription");
            scope.Start();
            try
            {
                var response = await SubscriptionRestClient.RenameAsync(Id.SubscriptionId, body, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to rename a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Subscription/rename</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Subscription_Rename</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="body"> Subscription Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public virtual Response<RenamedSubscriptionId> RenameSubscription(SubscriptionName body, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(body, nameof(body));

            using var scope = SubscriptionClientDiagnostics.CreateScope("MockableSubscriptionSubscriptionResource.RenameSubscription");
            scope.Start();
            try
            {
                var response = SubscriptionRestClient.Rename(Id.SubscriptionId, body, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to enable a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Subscription/enable</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Subscription_Enable</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<EnabledSubscriptionId>> EnableSubscriptionAsync(CancellationToken cancellationToken = default)
        {
            using var scope = SubscriptionClientDiagnostics.CreateScope("MockableSubscriptionSubscriptionResource.EnableSubscription");
            scope.Start();
            try
            {
                var response = await SubscriptionRestClient.EnableAsync(Id.SubscriptionId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to enable a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Subscription/enable</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Subscription_Enable</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<EnabledSubscriptionId> EnableSubscription(CancellationToken cancellationToken = default)
        {
            using var scope = SubscriptionClientDiagnostics.CreateScope("MockableSubscriptionSubscriptionResource.EnableSubscription");
            scope.Start();
            try
            {
                var response = SubscriptionRestClient.Enable(Id.SubscriptionId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
