// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Subscription.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableSubscriptionArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableSubscriptionArmClient"/> class for mocking. </summary>
        protected MockableSubscriptionArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableSubscriptionArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableSubscriptionArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableSubscriptionArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="SubscriptionAliasResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SubscriptionAliasResource.CreateResourceIdentifier" /> to create a <see cref="SubscriptionAliasResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SubscriptionAliasResource"/> object. </returns>
        public virtual SubscriptionAliasResource GetSubscriptionAliasResource(ResourceIdentifier id)
        {
            SubscriptionAliasResource.ValidateResourceId(id);
            return new SubscriptionAliasResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="TenantPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="TenantPolicyResource.CreateResourceIdentifier" /> to create a <see cref="TenantPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="TenantPolicyResource"/> object. </returns>
        public virtual TenantPolicyResource GetTenantPolicyResource(ResourceIdentifier id)
        {
            TenantPolicyResource.ValidateResourceId(id);
            return new TenantPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="BillingAccountPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BillingAccountPolicyResource.CreateResourceIdentifier" /> to create a <see cref="BillingAccountPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BillingAccountPolicyResource"/> object. </returns>
        public virtual BillingAccountPolicyResource GetBillingAccountPolicyResource(ResourceIdentifier id)
        {
            BillingAccountPolicyResource.ValidateResourceId(id);
            return new BillingAccountPolicyResource(Client, id);
        }
    }
}
