// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Subscription.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmSubscriptionModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.CanceledSubscriptionId"/>. </summary>
        /// <param name="subscriptionId"> The ID of the canceled subscription. </param>
        /// <returns> A new <see cref="Models.CanceledSubscriptionId"/> instance for mocking. </returns>
        public static CanceledSubscriptionId CanceledSubscriptionId(string subscriptionId = null)
        {
            return new CanceledSubscriptionId(subscriptionId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RenamedSubscriptionId"/>. </summary>
        /// <param name="subscriptionId"> The ID of the subscriptions that is being renamed. </param>
        /// <returns> A new <see cref="Models.RenamedSubscriptionId"/> instance for mocking. </returns>
        public static RenamedSubscriptionId RenamedSubscriptionId(string subscriptionId = null)
        {
            return new RenamedSubscriptionId(subscriptionId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EnabledSubscriptionId"/>. </summary>
        /// <param name="subscriptionId"> The ID of the subscriptions that is being enabled. </param>
        /// <returns> A new <see cref="Models.EnabledSubscriptionId"/> instance for mocking. </returns>
        public static EnabledSubscriptionId EnabledSubscriptionId(string subscriptionId = null)
        {
            return new EnabledSubscriptionId(subscriptionId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Subscription.SubscriptionAliasData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Subscription Alias response properties. </param>
        /// <returns> A new <see cref="Subscription.SubscriptionAliasData"/> instance for mocking. </returns>
        public static SubscriptionAliasData SubscriptionAliasData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SubscriptionAliasProperties properties = null)
        {
            return new SubscriptionAliasData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SubscriptionAliasProperties"/>. </summary>
        /// <param name="subscriptionId"> Newly created subscription Id. </param>
        /// <param name="displayName"> The display name of the subscription. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="acceptOwnershipUri"> Url to accept ownership of the subscription. </param>
        /// <param name="acceptOwnershipState"> The accept ownership state of the resource. </param>
        /// <param name="billingScope">
        /// Billing scope of the subscription.
        /// For CustomerLed and FieldLed - /billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}
        /// For PartnerLed - /billingAccounts/{billingAccountName}/customers/{customerName}
        /// For Legacy EA - /billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}
        /// </param>
        /// <param name="workload"> The workload type of the subscription. It can be either Production or DevTest. </param>
        /// <param name="resellerId"> Reseller Id. </param>
        /// <param name="subscriptionOwnerId"> Owner Id of the subscription. </param>
        /// <param name="managementGroupId"> The Management Group Id. </param>
        /// <param name="createdOn"> Created Time. </param>
        /// <param name="tags"> Tags for the subscription. </param>
        /// <returns> A new <see cref="Models.SubscriptionAliasProperties"/> instance for mocking. </returns>
        public static SubscriptionAliasProperties SubscriptionAliasProperties(string subscriptionId = null, string displayName = null, SubscriptionProvisioningState? provisioningState = null, Uri acceptOwnershipUri = null, AcceptOwnershipState? acceptOwnershipState = null, string billingScope = null, SubscriptionWorkload? workload = null, string resellerId = null, string subscriptionOwnerId = null, string managementGroupId = null, DateTimeOffset? createdOn = null, IReadOnlyDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SubscriptionAliasProperties(
                subscriptionId,
                displayName,
                provisioningState,
                acceptOwnershipUri,
                acceptOwnershipState,
                billingScope,
                workload,
                resellerId,
                subscriptionOwnerId,
                managementGroupId,
                createdOn,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AcceptOwnershipRequestProperties"/>. </summary>
        /// <param name="displayName"> The friendly name of the subscription. </param>
        /// <param name="managementGroupId"> Management group Id for the subscription. </param>
        /// <param name="tags"> Tags for the subscription. </param>
        /// <returns> A new <see cref="Models.AcceptOwnershipRequestProperties"/> instance for mocking. </returns>
        public static AcceptOwnershipRequestProperties AcceptOwnershipRequestProperties(string displayName = null, string managementGroupId = null, IDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new AcceptOwnershipRequestProperties(displayName, managementGroupId, tags, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AcceptOwnershipStatus"/>. </summary>
        /// <param name="subscriptionId"> Newly created subscription Id. </param>
        /// <param name="acceptOwnershipState"> The accept ownership state of the resource. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="billingOwner"> UPN of the billing owner. </param>
        /// <param name="subscriptionTenantId"> Tenant Id of the subscription. </param>
        /// <param name="displayName"> The display name of the subscription. </param>
        /// <param name="tags"> Tags for the subscription. </param>
        /// <returns> A new <see cref="Models.AcceptOwnershipStatus"/> instance for mocking. </returns>
        public static AcceptOwnershipStatus AcceptOwnershipStatus(string subscriptionId = null, AcceptOwnershipState? acceptOwnershipState = null, AcceptOwnershipProvisioningState? provisioningState = null, string billingOwner = null, Guid? subscriptionTenantId = null, string displayName = null, IReadOnlyDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new AcceptOwnershipStatus(
                subscriptionId,
                acceptOwnershipState,
                provisioningState,
                billingOwner,
                subscriptionTenantId,
                displayName,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Subscription.TenantPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Tenant policy properties. </param>
        /// <returns> A new <see cref="Subscription.TenantPolicyData"/> instance for mocking. </returns>
        public static TenantPolicyData TenantPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, TenantPolicyProperties properties = null)
        {
            return new TenantPolicyData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TenantPolicyProperties"/>. </summary>
        /// <param name="policyId"> Policy Id. </param>
        /// <param name="blockSubscriptionsLeavingTenant"> Blocks the leaving of subscriptions from user's tenant. </param>
        /// <param name="blockSubscriptionsIntoTenant"> Blocks the entering of subscriptions into user's tenant. </param>
        /// <param name="exemptedPrincipals"> List of user objectIds that are exempted from the set subscription tenant policies for the user's tenant. </param>
        /// <returns> A new <see cref="Models.TenantPolicyProperties"/> instance for mocking. </returns>
        public static TenantPolicyProperties TenantPolicyProperties(string policyId = null, bool? blockSubscriptionsLeavingTenant = null, bool? blockSubscriptionsIntoTenant = null, IEnumerable<Guid> exemptedPrincipals = null)
        {
            exemptedPrincipals ??= new List<Guid>();

            return new TenantPolicyProperties(policyId, blockSubscriptionsLeavingTenant, blockSubscriptionsIntoTenant, exemptedPrincipals?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Subscription.BillingAccountPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Billing account policies response properties. </param>
        /// <returns> A new <see cref="Subscription.BillingAccountPolicyData"/> instance for mocking. </returns>
        public static BillingAccountPolicyData BillingAccountPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, BillingAccountPolicyProperties properties = null)
        {
            return new BillingAccountPolicyData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BillingAccountPolicyProperties"/>. </summary>
        /// <param name="serviceTenants"> Service tenant for the billing account. </param>
        /// <param name="allowTransfers"> Determine if the transfers are allowed for the billing account. </param>
        /// <returns> A new <see cref="Models.BillingAccountPolicyProperties"/> instance for mocking. </returns>
        public static BillingAccountPolicyProperties BillingAccountPolicyProperties(IEnumerable<ServiceTenant> serviceTenants = null, bool? allowTransfers = null)
        {
            serviceTenants ??= new List<ServiceTenant>();

            return new BillingAccountPolicyProperties(serviceTenants?.ToList(), allowTransfers, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceTenant"/>. </summary>
        /// <param name="tenantId"> Service tenant id. </param>
        /// <param name="tenantName"> Service tenant name. </param>
        /// <returns> A new <see cref="Models.ServiceTenant"/> instance for mocking. </returns>
        public static ServiceTenant ServiceTenant(Guid? tenantId = null, string tenantName = null)
        {
            return new ServiceTenant(tenantId, tenantName, serializedAdditionalRawData: null);
        }
    }
}
