// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.StreamAnalytics
{
    /// <summary>
    /// A class representing a collection of <see cref="StreamingJobTransformationResource"/> and their operations.
    /// Each <see cref="StreamingJobTransformationResource"/> in the collection will belong to the same instance of <see cref="StreamingJobResource"/>.
    /// To get a <see cref="StreamingJobTransformationCollection"/> instance call the GetStreamingJobTransformations method from an instance of <see cref="StreamingJobResource"/>.
    /// </summary>
    public partial class StreamingJobTransformationCollection : ArmCollection
    {
        private readonly ClientDiagnostics _streamingJobTransformationTransformationsClientDiagnostics;
        private readonly TransformationsRestOperations _streamingJobTransformationTransformationsRestClient;

        /// <summary> Initializes a new instance of the <see cref="StreamingJobTransformationCollection"/> class for mocking. </summary>
        protected StreamingJobTransformationCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="StreamingJobTransformationCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal StreamingJobTransformationCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _streamingJobTransformationTransformationsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.StreamAnalytics", StreamingJobTransformationResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(StreamingJobTransformationResource.ResourceType, out string streamingJobTransformationTransformationsApiVersion);
            _streamingJobTransformationTransformationsRestClient = new TransformationsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, streamingJobTransformationTransformationsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != StreamingJobResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, StreamingJobResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates a transformation or replaces an already existing transformation under an existing streaming job.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/transformations/{transformationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transformations_CreateOrReplace</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StreamingJobTransformationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="transformationName"> The name of the transformation. </param>
        /// <param name="data"> The definition of the transformation that will be used to create a new transformation or replace the existing one under the streaming job. </param>
        /// <param name="ifMatch"> The ETag of the transformation. Omit this value to always overwrite the current transformation. Specify the last-seen ETag value to prevent accidentally overwriting concurrent changes. </param>
        /// <param name="ifNoneMatch"> Set to '*' to allow a new transformation to be created, but to prevent updating an existing transformation. Other values will result in a 412 Pre-condition Failed response. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformationName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<StreamingJobTransformationResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string transformationName, StreamingJobTransformationData data, string ifMatch = null, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformationName, nameof(transformationName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _streamingJobTransformationTransformationsClientDiagnostics.CreateScope("StreamingJobTransformationCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _streamingJobTransformationTransformationsRestClient.CreateOrReplaceAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformationName, data, ifMatch, ifNoneMatch, cancellationToken).ConfigureAwait(false);
                var uri = _streamingJobTransformationTransformationsRestClient.CreateCreateOrReplaceRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformationName, data, ifMatch, ifNoneMatch);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new StreamAnalyticsArmOperation<StreamingJobTransformationResource>(Response.FromValue(new StreamingJobTransformationResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a transformation or replaces an already existing transformation under an existing streaming job.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/transformations/{transformationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transformations_CreateOrReplace</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StreamingJobTransformationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="transformationName"> The name of the transformation. </param>
        /// <param name="data"> The definition of the transformation that will be used to create a new transformation or replace the existing one under the streaming job. </param>
        /// <param name="ifMatch"> The ETag of the transformation. Omit this value to always overwrite the current transformation. Specify the last-seen ETag value to prevent accidentally overwriting concurrent changes. </param>
        /// <param name="ifNoneMatch"> Set to '*' to allow a new transformation to be created, but to prevent updating an existing transformation. Other values will result in a 412 Pre-condition Failed response. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformationName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<StreamingJobTransformationResource> CreateOrUpdate(WaitUntil waitUntil, string transformationName, StreamingJobTransformationData data, string ifMatch = null, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformationName, nameof(transformationName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _streamingJobTransformationTransformationsClientDiagnostics.CreateScope("StreamingJobTransformationCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _streamingJobTransformationTransformationsRestClient.CreateOrReplace(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformationName, data, ifMatch, ifNoneMatch, cancellationToken);
                var uri = _streamingJobTransformationTransformationsRestClient.CreateCreateOrReplaceRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformationName, data, ifMatch, ifNoneMatch);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new StreamAnalyticsArmOperation<StreamingJobTransformationResource>(Response.FromValue(new StreamingJobTransformationResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets details about the specified transformation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/transformations/{transformationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transformations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StreamingJobTransformationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transformationName"> The name of the transformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformationName"/> is null. </exception>
        public virtual async Task<Response<StreamingJobTransformationResource>> GetAsync(string transformationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformationName, nameof(transformationName));

            using var scope = _streamingJobTransformationTransformationsClientDiagnostics.CreateScope("StreamingJobTransformationCollection.Get");
            scope.Start();
            try
            {
                var response = await _streamingJobTransformationTransformationsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformationName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new StreamingJobTransformationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets details about the specified transformation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/transformations/{transformationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transformations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StreamingJobTransformationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transformationName"> The name of the transformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformationName"/> is null. </exception>
        public virtual Response<StreamingJobTransformationResource> Get(string transformationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformationName, nameof(transformationName));

            using var scope = _streamingJobTransformationTransformationsClientDiagnostics.CreateScope("StreamingJobTransformationCollection.Get");
            scope.Start();
            try
            {
                var response = _streamingJobTransformationTransformationsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformationName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new StreamingJobTransformationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/transformations/{transformationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transformations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StreamingJobTransformationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transformationName"> The name of the transformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformationName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string transformationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformationName, nameof(transformationName));

            using var scope = _streamingJobTransformationTransformationsClientDiagnostics.CreateScope("StreamingJobTransformationCollection.Exists");
            scope.Start();
            try
            {
                var response = await _streamingJobTransformationTransformationsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformationName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/transformations/{transformationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transformations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StreamingJobTransformationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transformationName"> The name of the transformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformationName"/> is null. </exception>
        public virtual Response<bool> Exists(string transformationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformationName, nameof(transformationName));

            using var scope = _streamingJobTransformationTransformationsClientDiagnostics.CreateScope("StreamingJobTransformationCollection.Exists");
            scope.Start();
            try
            {
                var response = _streamingJobTransformationTransformationsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformationName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/transformations/{transformationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transformations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StreamingJobTransformationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transformationName"> The name of the transformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformationName"/> is null. </exception>
        public virtual async Task<NullableResponse<StreamingJobTransformationResource>> GetIfExistsAsync(string transformationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformationName, nameof(transformationName));

            using var scope = _streamingJobTransformationTransformationsClientDiagnostics.CreateScope("StreamingJobTransformationCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _streamingJobTransformationTransformationsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformationName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<StreamingJobTransformationResource>(response.GetRawResponse());
                return Response.FromValue(new StreamingJobTransformationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/transformations/{transformationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transformations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StreamingJobTransformationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transformationName"> The name of the transformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformationName"/> is null. </exception>
        public virtual NullableResponse<StreamingJobTransformationResource> GetIfExists(string transformationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformationName, nameof(transformationName));

            using var scope = _streamingJobTransformationTransformationsClientDiagnostics.CreateScope("StreamingJobTransformationCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _streamingJobTransformationTransformationsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformationName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<StreamingJobTransformationResource>(response.GetRawResponse());
                return Response.FromValue(new StreamingJobTransformationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
