// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Unknown version of StreamInputDataSource. </summary>
    internal partial class UnknownStreamInputDataSource : StreamInputDataSource
    {
        /// <summary> Initializes a new instance of <see cref="UnknownStreamInputDataSource"/>. </summary>
        /// <param name="streamInputDataSourceType"> Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnknownStreamInputDataSource(string streamInputDataSourceType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(streamInputDataSourceType, serializedAdditionalRawData)
        {
            StreamInputDataSourceType = streamInputDataSourceType ?? "Unknown";
        }

        /// <summary> Initializes a new instance of <see cref="UnknownStreamInputDataSource"/> for deserialization. </summary>
        internal UnknownStreamInputDataSource()
        {
        }
    }
}
