// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Describes an Azure Synapse output data source. </summary>
    public partial class SynapseOutputDataSource : StreamingJobOutputDataSource
    {
        /// <summary> Initializes a new instance of <see cref="SynapseOutputDataSource"/>. </summary>
        public SynapseOutputDataSource()
        {
            OutputDataSourceType = "Microsoft.Sql/Server/DataWarehouse";
        }

        /// <summary> Initializes a new instance of <see cref="SynapseOutputDataSource"/>. </summary>
        /// <param name="outputDataSourceType"> Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="server"> The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="database"> The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="table"> The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="user"> The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="password"> The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="authenticationMode"> Authentication Mode. </param>
        internal SynapseOutputDataSource(string outputDataSourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string server, string database, string table, string user, string password, StreamAnalyticsAuthenticationMode? authenticationMode) : base(outputDataSourceType, serializedAdditionalRawData)
        {
            Server = server;
            Database = database;
            Table = table;
            User = user;
            Password = password;
            AuthenticationMode = authenticationMode;
            OutputDataSourceType = outputDataSourceType ?? "Microsoft.Sql/Server/DataWarehouse";
        }

        /// <summary> The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests. </summary>
        public string Server { get; set; }
        /// <summary> The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests. </summary>
        public string Database { get; set; }
        /// <summary> The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests. </summary>
        public string Table { get; set; }
        /// <summary> The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests. </summary>
        public string User { get; set; }
        /// <summary> The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests. </summary>
        public string Password { get; set; }
        /// <summary> Authentication Mode. </summary>
        public StreamAnalyticsAuthenticationMode? AuthenticationMode { get; set; }
    }
}
