// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Describes the type of the job. Valid modes are `Cloud` and 'Edge'. </summary>
    public readonly partial struct StreamingJobType : IEquatable<StreamingJobType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamingJobType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamingJobType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CloudValue = "Cloud";
        private const string EdgeValue = "Edge";

        /// <summary> Cloud. </summary>
        public static StreamingJobType Cloud { get; } = new StreamingJobType(CloudValue);
        /// <summary> Edge. </summary>
        public static StreamingJobType Edge { get; } = new StreamingJobType(EdgeValue);
        /// <summary> Determines if two <see cref="StreamingJobType"/> values are the same. </summary>
        public static bool operator ==(StreamingJobType left, StreamingJobType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamingJobType"/> values are not the same. </summary>
        public static bool operator !=(StreamingJobType left, StreamingJobType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamingJobType"/>. </summary>
        public static implicit operator StreamingJobType(string value) => new StreamingJobType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamingJobType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamingJobType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
