// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> The properties that are associated with an Azure Storage account with MSI. </summary>
    public partial class StreamingJobStorageAccount : StreamAnalyticsStorageAccount
    {
        /// <summary> Initializes a new instance of <see cref="StreamingJobStorageAccount"/>. </summary>
        public StreamingJobStorageAccount()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StreamingJobStorageAccount"/>. </summary>
        /// <param name="accountName"> The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="accountKey"> The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests. </param>
        /// <param name="authenticationMode"> Authentication Mode. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StreamingJobStorageAccount(string accountName, string accountKey, StreamAnalyticsAuthenticationMode? authenticationMode, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(accountName, accountKey, authenticationMode, serializedAdditionalRawData)
        {
        }
    }
}
