// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> The current execution state of the streaming job. </summary>
    public readonly partial struct StreamingJobState : IEquatable<StreamingJobState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamingJobState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamingJobState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatedValue = "Created";
        private const string StartingValue = "Starting";
        private const string RunningValue = "Running";
        private const string StoppingValue = "Stopping";
        private const string StoppedValue = "Stopped";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";
        private const string DegradedValue = "Degraded";
        private const string RestartingValue = "Restarting";
        private const string ScalingValue = "Scaling";

        /// <summary> The job is currently in the Created state. </summary>
        public static StreamingJobState Created { get; } = new StreamingJobState(CreatedValue);
        /// <summary> The job is currently in the Starting state. </summary>
        public static StreamingJobState Starting { get; } = new StreamingJobState(StartingValue);
        /// <summary> The job is currently in the Running state. </summary>
        public static StreamingJobState Running { get; } = new StreamingJobState(RunningValue);
        /// <summary> The job is currently in the Stopping state. </summary>
        public static StreamingJobState Stopping { get; } = new StreamingJobState(StoppingValue);
        /// <summary> The job is currently in the Stopped state. </summary>
        public static StreamingJobState Stopped { get; } = new StreamingJobState(StoppedValue);
        /// <summary> The job is currently in the Deleting state. </summary>
        public static StreamingJobState Deleting { get; } = new StreamingJobState(DeletingValue);
        /// <summary> The job is currently in the Failed state. </summary>
        public static StreamingJobState Failed { get; } = new StreamingJobState(FailedValue);
        /// <summary> The job is currently in the Degraded state. </summary>
        public static StreamingJobState Degraded { get; } = new StreamingJobState(DegradedValue);
        /// <summary> The job is currently in the Restarting state. </summary>
        public static StreamingJobState Restarting { get; } = new StreamingJobState(RestartingValue);
        /// <summary> The job is currently in the Scaling state. </summary>
        public static StreamingJobState Scaling { get; } = new StreamingJobState(ScalingValue);
        /// <summary> Determines if two <see cref="StreamingJobState"/> values are the same. </summary>
        public static bool operator ==(StreamingJobState left, StreamingJobState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamingJobState"/> values are not the same. </summary>
        public static bool operator !=(StreamingJobState left, StreamingJobState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamingJobState"/>. </summary>
        public static implicit operator StreamingJobState(string value) => new StreamingJobState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamingJobState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamingJobState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
