// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    public partial class StreamingJobOutputWatermarkProperties : IUtf8JsonSerializable, IJsonModel<StreamingJobOutputWatermarkProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StreamingJobOutputWatermarkProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StreamingJobOutputWatermarkProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StreamingJobOutputWatermarkProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StreamingJobOutputWatermarkProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(WatermarkMode))
            {
                writer.WritePropertyName("watermarkMode"u8);
                writer.WriteStringValue(WatermarkMode.Value.ToString());
            }
            if (Optional.IsDefined(MaxWatermarkDifferenceAcrossPartitions))
            {
                writer.WritePropertyName("maxWatermarkDifferenceAcrossPartitions"u8);
                writer.WriteStringValue(MaxWatermarkDifferenceAcrossPartitions);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        StreamingJobOutputWatermarkProperties IJsonModel<StreamingJobOutputWatermarkProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StreamingJobOutputWatermarkProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StreamingJobOutputWatermarkProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStreamingJobOutputWatermarkProperties(document.RootElement, options);
        }

        internal static StreamingJobOutputWatermarkProperties DeserializeStreamingJobOutputWatermarkProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            StreamingJobOutputWatermarkMode? watermarkMode = default;
            string maxWatermarkDifferenceAcrossPartitions = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("watermarkMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    watermarkMode = new StreamingJobOutputWatermarkMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("maxWatermarkDifferenceAcrossPartitions"u8))
                {
                    maxWatermarkDifferenceAcrossPartitions = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StreamingJobOutputWatermarkProperties(watermarkMode, maxWatermarkDifferenceAcrossPartitions, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StreamingJobOutputWatermarkProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StreamingJobOutputWatermarkProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StreamingJobOutputWatermarkProperties)} does not support writing '{options.Format}' format.");
            }
        }

        StreamingJobOutputWatermarkProperties IPersistableModel<StreamingJobOutputWatermarkProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StreamingJobOutputWatermarkProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStreamingJobOutputWatermarkProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StreamingJobOutputWatermarkProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StreamingJobOutputWatermarkProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
