// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> The output watermark mode. </summary>
    public readonly partial struct StreamingJobOutputWatermarkMode : IEquatable<StreamingJobOutputWatermarkMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamingJobOutputWatermarkMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamingJobOutputWatermarkMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string SendCurrentPartitionWatermarkValue = "SendCurrentPartitionWatermark";
        private const string SendLowestWatermarkAcrossPartitionsValue = "SendLowestWatermarkAcrossPartitions";

        /// <summary> None. </summary>
        public static StreamingJobOutputWatermarkMode None { get; } = new StreamingJobOutputWatermarkMode(NoneValue);
        /// <summary> SendCurrentPartitionWatermark. </summary>
        public static StreamingJobOutputWatermarkMode SendCurrentPartitionWatermark { get; } = new StreamingJobOutputWatermarkMode(SendCurrentPartitionWatermarkValue);
        /// <summary> SendLowestWatermarkAcrossPartitions. </summary>
        public static StreamingJobOutputWatermarkMode SendLowestWatermarkAcrossPartitions { get; } = new StreamingJobOutputWatermarkMode(SendLowestWatermarkAcrossPartitionsValue);
        /// <summary> Determines if two <see cref="StreamingJobOutputWatermarkMode"/> values are the same. </summary>
        public static bool operator ==(StreamingJobOutputWatermarkMode left, StreamingJobOutputWatermarkMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamingJobOutputWatermarkMode"/> values are not the same. </summary>
        public static bool operator !=(StreamingJobOutputWatermarkMode left, StreamingJobOutputWatermarkMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamingJobOutputWatermarkMode"/>. </summary>
        public static implicit operator StreamingJobOutputWatermarkMode(string value) => new StreamingJobOutputWatermarkMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamingJobOutputWatermarkMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamingJobOutputWatermarkMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
