// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time. </summary>
    public readonly partial struct StreamingJobOutputStartMode : IEquatable<StreamingJobOutputStartMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamingJobOutputStartMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamingJobOutputStartMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string JobStartTimeValue = "JobStartTime";
        private const string CustomTimeValue = "CustomTime";
        private const string LastOutputEventTimeValue = "LastOutputEventTime";

        /// <summary> JobStartTime. </summary>
        public static StreamingJobOutputStartMode JobStartTime { get; } = new StreamingJobOutputStartMode(JobStartTimeValue);
        /// <summary> CustomTime. </summary>
        public static StreamingJobOutputStartMode CustomTime { get; } = new StreamingJobOutputStartMode(CustomTimeValue);
        /// <summary> LastOutputEventTime. </summary>
        public static StreamingJobOutputStartMode LastOutputEventTime { get; } = new StreamingJobOutputStartMode(LastOutputEventTimeValue);
        /// <summary> Determines if two <see cref="StreamingJobOutputStartMode"/> values are the same. </summary>
        public static bool operator ==(StreamingJobOutputStartMode left, StreamingJobOutputStartMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamingJobOutputStartMode"/> values are not the same. </summary>
        public static bool operator !=(StreamingJobOutputStartMode left, StreamingJobOutputStartMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamingJobOutputStartMode"/>. </summary>
        public static implicit operator StreamingJobOutputStartMode(string value) => new StreamingJobOutputStartMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamingJobOutputStartMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamingJobOutputStartMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
