// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to being malformed (missing column values, column values of wrong type or size). </summary>
    public readonly partial struct StreamingJobOutputErrorPolicy : IEquatable<StreamingJobOutputErrorPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamingJobOutputErrorPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamingJobOutputErrorPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StopValue = "Stop";
        private const string DropValue = "Drop";

        /// <summary> Stop. </summary>
        public static StreamingJobOutputErrorPolicy Stop { get; } = new StreamingJobOutputErrorPolicy(StopValue);
        /// <summary> Drop. </summary>
        public static StreamingJobOutputErrorPolicy Drop { get; } = new StreamingJobOutputErrorPolicy(DropValue);
        /// <summary> Determines if two <see cref="StreamingJobOutputErrorPolicy"/> values are the same. </summary>
        public static bool operator ==(StreamingJobOutputErrorPolicy left, StreamingJobOutputErrorPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamingJobOutputErrorPolicy"/> values are not the same. </summary>
        public static bool operator !=(StreamingJobOutputErrorPolicy left, StreamingJobOutputErrorPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamingJobOutputErrorPolicy"/>. </summary>
        public static implicit operator StreamingJobOutputErrorPolicy(string value) => new StreamingJobOutputErrorPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamingJobOutputErrorPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamingJobOutputErrorPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
