// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    [PersistableModelProxy(typeof(UnknownOutputDataSource))]
    public partial class StreamingJobOutputDataSource : IUtf8JsonSerializable, IJsonModel<StreamingJobOutputDataSource>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StreamingJobOutputDataSource>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StreamingJobOutputDataSource>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StreamingJobOutputDataSource>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StreamingJobOutputDataSource)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("type"u8);
            writer.WriteStringValue(OutputDataSourceType);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        StreamingJobOutputDataSource IJsonModel<StreamingJobOutputDataSource>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StreamingJobOutputDataSource>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StreamingJobOutputDataSource)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStreamingJobOutputDataSource(document.RootElement, options);
        }

        internal static StreamingJobOutputDataSource DeserializeStreamingJobOutputDataSource(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("type", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "GatewayMessageBus": return GatewayMessageBusOutputDataSource.DeserializeGatewayMessageBusOutputDataSource(element, options);
                    case "Microsoft.AzureFunction": return FunctionOutputDataSource.DeserializeFunctionOutputDataSource(element, options);
                    case "Microsoft.DataLake/Accounts": return DataLakeStoreOutputDataSource.DeserializeDataLakeStoreOutputDataSource(element, options);
                    case "Microsoft.DBForPostgreSQL/servers/databases": return PostgreSQLOutputDataSource.DeserializePostgreSQLOutputDataSource(element, options);
                    case "Microsoft.EventHub/EventHub": return EventHubV2OutputDataSource.DeserializeEventHubV2OutputDataSource(element, options);
                    case "Microsoft.ServiceBus/EventHub": return EventHubOutputDataSource.DeserializeEventHubOutputDataSource(element, options);
                    case "Microsoft.ServiceBus/Queue": return ServiceBusQueueOutputDataSource.DeserializeServiceBusQueueOutputDataSource(element, options);
                    case "Microsoft.ServiceBus/Topic": return ServiceBusTopicOutputDataSource.DeserializeServiceBusTopicOutputDataSource(element, options);
                    case "Microsoft.Sql/Server/Database": return SqlDatabaseOutputDataSource.DeserializeSqlDatabaseOutputDataSource(element, options);
                    case "Microsoft.Sql/Server/DataWarehouse": return SynapseOutputDataSource.DeserializeSynapseOutputDataSource(element, options);
                    case "Microsoft.Storage/Blob": return BlobOutputDataSource.DeserializeBlobOutputDataSource(element, options);
                    case "Microsoft.Storage/DocumentDB": return DocumentDbOutputDataSource.DeserializeDocumentDbOutputDataSource(element, options);
                    case "Microsoft.Storage/Table": return TableOutputDataSource.DeserializeTableOutputDataSource(element, options);
                    case "PowerBI": return PowerBIOutputDataSource.DeserializePowerBIOutputDataSource(element, options);
                    case "Raw": return RawOutputDatasource.DeserializeRawOutputDatasource(element, options);
                }
            }
            return UnknownOutputDataSource.DeserializeUnknownOutputDataSource(element, options);
        }

        BinaryData IPersistableModel<StreamingJobOutputDataSource>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StreamingJobOutputDataSource>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StreamingJobOutputDataSource)} does not support writing '{options.Format}' format.");
            }
        }

        StreamingJobOutputDataSource IPersistableModel<StreamingJobOutputDataSource>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StreamingJobOutputDataSource>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStreamingJobOutputDataSource(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StreamingJobOutputDataSource)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StreamingJobOutputDataSource>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
