// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Settings which determine whether to read watermark events. </summary>
    internal partial class StreamingJobInputWatermarkProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StreamingJobInputWatermarkProperties"/>. </summary>
        public StreamingJobInputWatermarkProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StreamingJobInputWatermarkProperties"/>. </summary>
        /// <param name="watermarkMode"> The input watermark mode. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StreamingJobInputWatermarkProperties(StreamingJobInputWatermarkMode? watermarkMode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            WatermarkMode = watermarkMode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The input watermark mode. </summary>
        public StreamingJobInputWatermarkMode? WatermarkMode { get; set; }
    }
}
