// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> The input watermark mode. </summary>
    public readonly partial struct StreamingJobInputWatermarkMode : IEquatable<StreamingJobInputWatermarkMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamingJobInputWatermarkMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamingJobInputWatermarkMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ReadWatermarkValue = "ReadWatermark";

        /// <summary> None. </summary>
        public static StreamingJobInputWatermarkMode None { get; } = new StreamingJobInputWatermarkMode(NoneValue);
        /// <summary> ReadWatermark. </summary>
        public static StreamingJobInputWatermarkMode ReadWatermark { get; } = new StreamingJobInputWatermarkMode(ReadWatermarkValue);
        /// <summary> Determines if two <see cref="StreamingJobInputWatermarkMode"/> values are the same. </summary>
        public static bool operator ==(StreamingJobInputWatermarkMode left, StreamingJobInputWatermarkMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamingJobInputWatermarkMode"/> values are not the same. </summary>
        public static bool operator !=(StreamingJobInputWatermarkMode left, StreamingJobInputWatermarkMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamingJobInputWatermarkMode"/>. </summary>
        public static implicit operator StreamingJobInputWatermarkMode(string value) => new StreamingJobInputWatermarkMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamingJobInputWatermarkMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamingJobInputWatermarkMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
