// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Refresh modes for Stream Analytics functions. </summary>
    public readonly partial struct StreamingJobFunctionUpdateMode : IEquatable<StreamingJobFunctionUpdateMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamingJobFunctionUpdateMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamingJobFunctionUpdateMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StaticValue = "Static";
        private const string RefreshableValue = "Refreshable";

        /// <summary> Static. </summary>
        public static StreamingJobFunctionUpdateMode Static { get; } = new StreamingJobFunctionUpdateMode(StaticValue);
        /// <summary> Refreshable. </summary>
        public static StreamingJobFunctionUpdateMode Refreshable { get; } = new StreamingJobFunctionUpdateMode(RefreshableValue);
        /// <summary> Determines if two <see cref="StreamingJobFunctionUpdateMode"/> values are the same. </summary>
        public static bool operator ==(StreamingJobFunctionUpdateMode left, StreamingJobFunctionUpdateMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamingJobFunctionUpdateMode"/> values are not the same. </summary>
        public static bool operator !=(StreamingJobFunctionUpdateMode left, StreamingJobFunctionUpdateMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamingJobFunctionUpdateMode"/>. </summary>
        public static implicit operator StreamingJobFunctionUpdateMode(string value) => new StreamingJobFunctionUpdateMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamingJobFunctionUpdateMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamingJobFunctionUpdateMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
