// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Describes one input parameter of a function. </summary>
    public partial class StreamingJobFunctionInput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StreamingJobFunctionInput"/>. </summary>
        public StreamingJobFunctionInput()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StreamingJobFunctionInput"/>. </summary>
        /// <param name="dataType"> The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx. </param>
        /// <param name="isConfigurationParameter"> A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant. Default is false. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StreamingJobFunctionInput(string dataType, bool? isConfigurationParameter, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DataType = dataType;
            IsConfigurationParameter = isConfigurationParameter;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx. </summary>
        public string DataType { get; set; }
        /// <summary> A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant. Default is false. </summary>
        public bool? IsConfigurationParameter { get; set; }
    }
}
