// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> The storage account where the custom code artifacts are located. </summary>
    public partial class StreamingJobExternal
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StreamingJobExternal"/>. </summary>
        public StreamingJobExternal()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StreamingJobExternal"/>. </summary>
        /// <param name="storageAccount"> The properties that are associated with an Azure Storage account. </param>
        /// <param name="container"> The UserCustomCode container. </param>
        /// <param name="path"> The UserCustomCode path. </param>
        /// <param name="refreshConfiguration"> The refresh parameters for any/all updatable user defined functions present in the job config. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StreamingJobExternal(StreamAnalyticsStorageAccount storageAccount, string container, string path, StreamingJobRefreshConfiguration refreshConfiguration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StorageAccount = storageAccount;
            Container = container;
            Path = path;
            RefreshConfiguration = refreshConfiguration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The properties that are associated with an Azure Storage account. </summary>
        public StreamAnalyticsStorageAccount StorageAccount { get; set; }
        /// <summary> The UserCustomCode container. </summary>
        public string Container { get; set; }
        /// <summary> The UserCustomCode path. </summary>
        public string Path { get; set; }
        /// <summary> The refresh parameters for any/all updatable user defined functions present in the job config. </summary>
        public StreamingJobRefreshConfiguration RefreshConfiguration { get; set; }
    }
}
