// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Controls certain runtime behaviors of the streaming job. </summary>
    public readonly partial struct StreamingJobCompatibilityLevel : IEquatable<StreamingJobCompatibilityLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamingJobCompatibilityLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamingJobCompatibilityLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Level1_0Value = "1.0";
        private const string Level1_2Value = "1.2";
        /// <summary> Determines if two <see cref="StreamingJobCompatibilityLevel"/> values are the same. </summary>
        public static bool operator ==(StreamingJobCompatibilityLevel left, StreamingJobCompatibilityLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamingJobCompatibilityLevel"/> values are not the same. </summary>
        public static bool operator !=(StreamingJobCompatibilityLevel left, StreamingJobCompatibilityLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamingJobCompatibilityLevel"/>. </summary>
        public static implicit operator StreamingJobCompatibilityLevel(string value) => new StreamingJobCompatibilityLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamingJobCompatibilityLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamingJobCompatibilityLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
