// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Indicates the type of compression that the input uses. Required on PUT (CreateOrReplace) requests. </summary>
    public readonly partial struct StreamingCompressionType : IEquatable<StreamingCompressionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamingCompressionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamingCompressionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string GzipValue = "GZip";
        private const string DeflateValue = "Deflate";

        /// <summary> None. </summary>
        public static StreamingCompressionType None { get; } = new StreamingCompressionType(NoneValue);
        /// <summary> GZip. </summary>
        public static StreamingCompressionType Gzip { get; } = new StreamingCompressionType(GzipValue);
        /// <summary> Deflate. </summary>
        public static StreamingCompressionType Deflate { get; } = new StreamingCompressionType(DeflateValue);
        /// <summary> Determines if two <see cref="StreamingCompressionType"/> values are the same. </summary>
        public static bool operator ==(StreamingCompressionType left, StreamingCompressionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamingCompressionType"/> values are not the same. </summary>
        public static bool operator !=(StreamingCompressionType left, StreamingCompressionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamingCompressionType"/>. </summary>
        public static implicit operator StreamingCompressionType(string value) => new StreamingCompressionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamingCompressionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamingCompressionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
