// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> A stream analytics output. </summary>
    public partial class StreamAnalyticsTestOutput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsTestOutput"/>. </summary>
        /// <param name="output"> The stream analytics output to test. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="output"/> is null. </exception>
        public StreamAnalyticsTestOutput(StreamingJobOutputData output)
        {
            Argument.AssertNotNull(output, nameof(output));

            Output = output;
        }

        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsTestOutput"/>. </summary>
        /// <param name="output"> The stream analytics output to test. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StreamAnalyticsTestOutput(StreamingJobOutputData output, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Output = output;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsTestOutput"/> for deserialization. </summary>
        internal StreamAnalyticsTestOutput()
        {
        }

        /// <summary> The stream analytics output to test. </summary>
        public StreamingJobOutputData Output { get; }
    }
}
