// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> The result of the test input or output request. </summary>
    public partial class StreamAnalyticsTestDatasourceResult : StreamAnalyticsError
    {
        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsTestDatasourceResult"/>. </summary>
        internal StreamAnalyticsTestDatasourceResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsTestDatasourceResult"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="target"> Error target. </param>
        /// <param name="details"> Error details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="status"> The status of the sample output request. </param>
        internal StreamAnalyticsTestDatasourceResult(string code, string message, string target, IReadOnlyList<StreamAnalyticsErrorDetails> details, IDictionary<string, BinaryData> serializedAdditionalRawData, StreamAnalyticsTestDatasourceResultStatus? status) : base(code, message, target, details, serializedAdditionalRawData)
        {
            Status = status;
        }

        /// <summary> The status of the sample output request. </summary>
        public StreamAnalyticsTestDatasourceResultStatus? Status { get; }
    }
}
