// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> Describes the current quota for the subscription. </summary>
    public partial class StreamAnalyticsSubscriptionQuota : StreamAnalyticsSubResource
    {
        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsSubscriptionQuota"/>. </summary>
        public StreamAnalyticsSubscriptionQuota()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsSubscriptionQuota"/>. </summary>
        /// <param name="id"> Resource Id. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="maxCount"> The max permitted usage of this resource. </param>
        /// <param name="currentCount"> The current usage of this resource. </param>
        internal StreamAnalyticsSubscriptionQuota(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, int? maxCount, int? currentCount) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            MaxCount = maxCount;
            CurrentCount = currentCount;
        }

        /// <summary> The max permitted usage of this resource. </summary>
        public int? MaxCount { get; }
        /// <summary> The current usage of this resource. </summary>
        public int? CurrentCount { get; }
    }
}
