// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StreamAnalytics.Models
{
    /// <summary> The status of the sample input request. </summary>
    public readonly partial struct StreamAnalyticsSampleInputResultStatus : IEquatable<StreamAnalyticsSampleInputResultStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StreamAnalyticsSampleInputResultStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StreamAnalyticsSampleInputResultStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadAllEventsInRangeValue = "ReadAllEventsInRange";
        private const string NoEventsFoundInRangeValue = "NoEventsFoundInRange";
        private const string ErrorConnectingToInputValue = "ErrorConnectingToInput";

        /// <summary> The sample input operation successfully read all the events in the range. </summary>
        public static StreamAnalyticsSampleInputResultStatus ReadAllEventsInRange { get; } = new StreamAnalyticsSampleInputResultStatus(ReadAllEventsInRangeValue);
        /// <summary> The sample input operation found no events in the range. </summary>
        public static StreamAnalyticsSampleInputResultStatus NoEventsFoundInRange { get; } = new StreamAnalyticsSampleInputResultStatus(NoEventsFoundInRangeValue);
        /// <summary> The sample input operation failed to connect to the input. </summary>
        public static StreamAnalyticsSampleInputResultStatus ErrorConnectingToInput { get; } = new StreamAnalyticsSampleInputResultStatus(ErrorConnectingToInputValue);
        /// <summary> Determines if two <see cref="StreamAnalyticsSampleInputResultStatus"/> values are the same. </summary>
        public static bool operator ==(StreamAnalyticsSampleInputResultStatus left, StreamAnalyticsSampleInputResultStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StreamAnalyticsSampleInputResultStatus"/> values are not the same. </summary>
        public static bool operator !=(StreamAnalyticsSampleInputResultStatus left, StreamAnalyticsSampleInputResultStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StreamAnalyticsSampleInputResultStatus"/>. </summary>
        public static implicit operator StreamAnalyticsSampleInputResultStatus(string value) => new StreamAnalyticsSampleInputResultStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StreamAnalyticsSampleInputResultStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StreamAnalyticsSampleInputResultStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
